/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.provider.IAIK;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Random;

public class DumpKeyStore {
    private static String a = System.getProperty("file.separator");

    public static void saveToPKCS12(String string, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string2, boolean bl, char[] cArray, boolean bl2) throws IOException {
        block15: {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            try {
                try {
                    Object object;
                    String string3 = string != null ? string : DumpKeyStore.a(x509CertificateArray[0]);
                    byte[] byArray = DumpKeyStore.a(x509CertificateArray[0], string3);
                    int n2 = x509CertificateArray.length;
                    if (!bl2) {
                        n2 = 1;
                    }
                    CertificateBag[] certificateBagArray = new CertificateBag[n2];
                    certificateBagArray[n2 - 1] = new CertificateBag(x509CertificateArray[0]);
                    certificateBagArray[n2 - 1].setFriendlyName(string3);
                    certificateBagArray[n2 - 1].setLocalKeyID(byArray);
                    if (bl2) {
                        int n3 = 1;
                        while (n3 < n2) {
                            certificateBagArray[n2 - 1 - n3] = new CertificateBag(x509CertificateArray[n3]);
                            try {
                                object = DumpKeyStore.a(x509CertificateArray[n3]);
                                if (object != null) {
                                    certificateBagArray[n2 - 1 - n3].setFriendlyName((String)object);
                                }
                            }
                            catch (Exception exception) {}
                            ++n3;
                        }
                    }
                    KeyBag keyBag = new KeyBag(privateKey, string3, byArray);
                    object = new PKCS12(keyBag, certificateBagArray, true);
                    ((PKCS12)object).encrypt(cArray);
                    if (bl) {
                        ((PKCS12)object).writeTo(fileOutputStream);
                    } else {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ((PKCS12)object).writeTo(byteArrayOutputStream);
                        PrintWriter printWriter = new PrintWriter(fileOutputStream);
                        printWriter.println("-----BEGIN PKCS12-----");
                        printWriter.println(new String(Util.Base64Encode(byteArrayOutputStream.toByteArray())));
                        printWriter.println("-----END PKCS12-----");
                        printWriter.close();
                    }
                }
                catch (PKCSException pKCSException) {
                    throw new IOException(pKCSException.getMessage());
                }
                Object var9_18 = null;
                if (fileOutputStream == null) break block15;
            }
            catch (Throwable throwable) {
                block16: {
                    Object var9_19 = null;
                    if (fileOutputStream == null) break block16;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveCertificateChain(X509Certificate[] x509CertificateArray, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        FileOutputStream fileOutputStream;
        block19: {
            fileOutputStream = null;
            try {
                block20: {
                    int n2;
                    fileOutputStream = new FileOutputStream(string);
                    if (bl2) {
                        PKCS7CertList pKCS7CertList = new PKCS7CertList();
                        if (bl3) {
                            pKCS7CertList.setCertificateList(x509CertificateArray);
                        } else {
                            pKCS7CertList.setCertificateList(new X509Certificate[]{x509CertificateArray[0]});
                        }
                        if (bl) {
                            pKCS7CertList.writeTo(fileOutputStream);
                        } else {
                            try {
                                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                                printWriter.println("-----BEGIN PKCS7-----");
                                printWriter.println(new String(Util.Base64Encode(pKCS7CertList.toByteArray())));
                                printWriter.println("-----END PKCS7-----");
                                printWriter.close();
                            }
                            catch (PKCSException pKCSException) {
                                throw new IOException(pKCSException.getMessage());
                            }
                        }
                        Object var7_13 = null;
                        if (fileOutputStream == null) return;
                        break block19;
                    }
                    int n3 = n2 = bl3 ? x509CertificateArray.length : 1;
                    if (bl) {
                        int n4 = 0;
                        while (n4 < n2) {
                            x509CertificateArray[n4].writeTo(fileOutputStream);
                            ++n4;
                        }
                        break block20;
                    }
                    PrintWriter printWriter = new PrintWriter(fileOutputStream);
                    int n5 = 0;
                    while (true) {
                        if (n5 >= n2) {
                            printWriter.close();
                            break;
                        }
                        printWriter.println("-----BEGIN CERTIFICATE-----");
                        printWriter.println(new String(Util.Base64Encode(x509CertificateArray[n5].toByteArray())));
                        printWriter.println("-----END CERTIFICATE-----");
                        ++n5;
                    }
                }
                Object var7_14 = null;
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                if (fileOutputStream == null) throw throwable;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                fileOutputStream.flush();
                fileOutputStream.close();
                throw throwable;
            }
            try {
                fileOutputStream.flush();
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {}
        catch (IOException iOException) {}
        fileOutputStream.flush();
        fileOutputStream.close();
        return;
    }

    private static final void a() {
        System.out.println("Usage:\n");
        System.out.println("java DumpKeyStore <KeyStore File> <Out Dir> <password> [<KeyStore Type>]\n");
        System.out.println("e.g.:");
        System.out.println("java DumpKeyStore keystore.ks certs/ks password IAIKKeyStore\n");
    }

    private static byte[] a(X509Certificate x509Certificate, String string) {
        Object object;
        byte[] byArray = null;
        try {
            object = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            if (object != null) {
                byArray = ((SubjectKeyIdentifier)object).get();
            }
        }
        catch (Exception exception) {}
        if (byArray == null) {
            try {
                byArray = new SubjectKeyIdentifier(x509Certificate.getPublicKey()).get();
            }
            catch (Exception exception) {}
        }
        if (byArray == null) {
            try {
                byArray = x509Certificate.getFingerprint();
            }
            catch (Exception exception) {}
        }
        if (byArray == null && string != null) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = string.getBytes();
                }
            }
        }
        if (byArray == null) {
            object = new Random();
            byArray = new byte[8];
            ((Random)object).nextBytes(byArray);
        }
        return byArray;
    }

    public static void main(String[] stringArray) {
        IAIK.addAsJDK14Provider();
        if (stringArray.length < 3 || stringArray.length > 4) {
            DumpKeyStore.a();
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        char[] cArray = stringArray[2].toCharArray();
        String string3 = stringArray.length == 4 ? stringArray[3] : "IAIKKeyStore";
        DumpKeyStore dumpKeyStore = new DumpKeyStore();
        dumpKeyStore.dump(string, string2, cArray, string3);
    }

    private static String a(X509Certificate x509Certificate) {
        Name name = (Name)x509Certificate.getSubjectDN();
        String string = null;
        if (name != null && (string = name.getRDN(ObjectID.commonName)) == null) {
            string = name.toString();
        }
        return string;
    }

    private static final void a(String string) {
        System.err.println(string);
        Util.waitKey();
        System.exit(-1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(String string, String string2, char[] cArray, String string3) {
        Enumeration<String> enumeration;
        String string4;
        String string5;
        KeyStore keyStore;
        block31: {
            File file;
            File file2;
            FileInputStream fileInputStream = null;
            keyStore = null;
            File file3 = new File(string2);
            if (!file3.exists()) {
                DumpKeyStore.a("Output directory \"" + string2 + "\" does not exist");
            }
            if (!file3.isDirectory()) {
                DumpKeyStore.a("\"" + string2 + "\" must be a directory!");
            }
            if (!(file2 = new File(string5 = String.valueOf(file3.getAbsolutePath()) + a + "keys")).exists()) {
                file2.mkdir();
            }
            if (!(file = new File(string4 = String.valueOf(file3.getAbsolutePath()) + a + "certs")).exists()) {
                file.mkdir();
            }
            try {
                try {
                    fileInputStream = new FileInputStream(string);
                    keyStore = KeyStore.getInstance(string3);
                    System.out.println("Loading keystore from " + string);
                    keyStore.load(fileInputStream, cArray);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DumpKeyStore.a("File not found " + fileNotFoundException.getMessage());
                }
                catch (Exception exception) {
                    DumpKeyStore.a("Error loading KeyStore: " + exception.toString());
                }
                enumeration = null;
                if (fileInputStream == null) break block31;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            fileInputStream.close();
        }
        int n2 = 0;
        try {
            enumeration = keyStore.aliases();
            while (true) {
                Certificate certificate;
                String string6;
                Object object;
                Certificate[] certificateArray;
                if (!enumeration.hasMoreElements()) {
                    System.out.println("Done! Processed " + n2 + " entries");
                    return;
                }
                String string7 = enumeration.nextElement();
                System.out.println("Processing entry " + string7);
                ++n2;
                if (keyStore.isKeyEntry(string7)) {
                    void var15_23;
                    Object var15_21 = null;
                    try {
                        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string7, cArray);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error reading key: " + exception.toString());
                    }
                    certificateArray = keyStore.getCertificateChain(string7);
                    if (var15_23 == null || certificateArray == null) continue;
                    object = null;
                    try {
                        object = Util.convertCertificateChain(certificateArray);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error reading certificate: " + exception.toString());
                    }
                    string6 = String.valueOf(string5) + a + DumpKeyStore.a((X509Certificate)object[0]);
                    string6 = string6.replace(' ', '_');
                    String string8 = String.valueOf(string6) + ".p12";
                    System.out.println("Saving key and certificate to " + string8);
                    try {
                        DumpKeyStore.saveToPKCS12(string7, (X509Certificate[])object, (PrivateKey)var15_23, string8, true, cArray, true);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving PKCS#12 file: " + exception.toString());
                    }
                    String string9 = String.valueOf(string6) + ".p7c";
                    System.out.println("Saving certificate chain to " + string9);
                    try {
                        DumpKeyStore.saveCertificateChain((X509Certificate[])object, string9, true, true, true);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving PKCS#7 file: " + exception.toString());
                    }
                    String string10 = String.valueOf(string6) + ".der";
                    System.out.println("Saving certificate " + string10);
                    try {
                        DumpKeyStore.saveCertificateChain((X509Certificate[])object, string10, true, false, false);
                    }
                    catch (Exception exception) {
                        DumpKeyStore.a("Error saving certificate: " + exception.toString());
                    }
                    continue;
                }
                if (!keyStore.isCertificateEntry(string7) || (certificate = keyStore.getCertificate(string7)) == null) continue;
                certificateArray = null;
                try {
                    certificateArray = Util.convertCertificate(certificate);
                }
                catch (Exception exception) {
                    DumpKeyStore.a("Error reading certificate: " + exception.toString());
                }
                object = String.valueOf(string4) + a + DumpKeyStore.a((X509Certificate)certificateArray);
                object = ((String)object).replace(' ', '_');
                string6 = String.valueOf(object) + ".der";
                System.out.println("Saving certificate " + string6);
                try {
                    DumpKeyStore.saveCertificateChain(new X509Certificate[]{certificateArray}, string6, true, false, false);
                }
                catch (Exception exception) {
                    DumpKeyStore.a("Error saving certificate: " + exception.toString());
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            DumpKeyStore.a("Error reading KeyStore: " + keyStoreException.toString());
            return;
        }
    }
}

