/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class ChangeElementTreeViewer
extends CheckboxTreeViewer {
    private static final DerivedFilter DERIVED_FILTER = new DerivedFilter();
    private List fDeferredTreeItemUpdates;

    public ChangeElementTreeViewer(Composite parentComposite) {
        super(parentComposite, 0);
        this.addFilter(new GroupCategoryFilter());
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PreviewNode element = (PreviewNode)event.getElement();
                boolean checked = event.getChecked();
                element.setEnabled(checked);
                ChangeElementTreeViewer.this.setSubtreeChecked(element, checked);
                ChangeElementTreeViewer.this.setSubtreeGrayed(element, false);
                PreviewNode parent = element.getParent();
                while (parent != null) {
                    int active = parent.getActive();
                    parent.setEnabledShallow(active == 1 || active == 2);
                    boolean grayed = active == 1;
                    ChangeElementTreeViewer.this.setChecked(parent, checked ? true : grayed);
                    ChangeElementTreeViewer.this.setGrayed(parent, grayed);
                    parent = parent.getParent();
                }
            }
        });
    }

    public void setGroupCategory(List groupCategories) {
        ((GroupCategoryFilter)this.getFilters()[0]).setGroupCategory(groupCategories);
        this.refresh();
    }

    public void setHideDerived(boolean hide) {
        if (hide) {
            this.addFilter(DERIVED_FILTER);
        } else {
            this.removeFilter(DERIVED_FILTER);
        }
    }

    public void refresh() {
        try {
            this.fDeferredTreeItemUpdates = new ArrayList();
            super.refresh();
            this.processDeferredTreeItemUpdates();
        }
        finally {
            this.fDeferredTreeItemUpdates = null;
        }
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        PreviewNode next = this.getLeaf((PreviewNode)this.getInput(), true);
        if (next != null) {
            newSelection = new StructuredSelection((Object)next);
            this.setSelection(newSelection);
        }
        super.handleInvalidSelection(invalidSelection, newSelection);
    }

    protected void inputChanged(Object input, Object oldInput) {
        try {
            this.fDeferredTreeItemUpdates = new ArrayList();
            super.inputChanged(input, oldInput);
            this.processDeferredTreeItemUpdates();
        }
        finally {
            this.fDeferredTreeItemUpdates = null;
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        if (this.fDeferredTreeItemUpdates == null) {
            this.applyCheckedState((TreeItem)item, (PreviewNode)element);
        } else {
            this.fDeferredTreeItemUpdates.add(item);
        }
    }

    private void processDeferredTreeItemUpdates() {
        Iterator iter = this.fDeferredTreeItemUpdates.iterator();
        while (iter.hasNext()) {
            TreeItem item = (TreeItem)iter.next();
            this.applyCheckedState(item, (PreviewNode)item.getData());
        }
    }

    private void applyCheckedState(TreeItem item, PreviewNode ce) {
        int state = ce.getActive();
        boolean checked = state != 0;
        item.setChecked(checked);
        boolean grayed = state == 1;
        item.setGrayed(grayed);
    }

    protected void revealNext() {
        this.revealElement(true);
    }

    protected void revealPrevious() {
        this.revealElement(false);
    }

    private void setSubtreeGrayed(Object element, boolean grayed) {
        TreeItem item;
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem && (item = (TreeItem)widget).getGrayed() != grayed) {
            item.setGrayed(grayed);
            this.grayChildren(this.getChildren((Widget)item), grayed);
        }
    }

    private void grayChildren(Item[] items, boolean grayed) {
        int i = 0;
        while (i < items.length) {
            TreeItem item;
            Item element = items[i];
            if (element instanceof TreeItem && (item = (TreeItem)element).getGrayed() != grayed) {
                item.setGrayed(grayed);
                this.grayChildren(this.getChildren((Widget)item), grayed);
            }
            ++i;
        }
    }

    private void revealElement(boolean next) {
        PreviewNode leaf;
        PreviewNode candidate;
        PreviewNode current = (PreviewNode)this.getInput();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (!selection.isEmpty()) {
            current = (PreviewNode)selection.iterator().next();
        }
        if ((candidate = this.getLeaf(current, next)) == null && (candidate = this.getElement(current, next)) != null && (leaf = this.getLeaf(candidate, next)) != null) {
            candidate = leaf;
        }
        if (candidate != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)candidate), true);
        } else {
            this.getControl().getDisplay().beep();
        }
    }

    private PreviewNode getLeaf(PreviewNode element, boolean first) {
        PreviewNode result = null;
        PreviewNode[] children = this.getSortedChildrenAsPreviewNodes(element);
        while (children != null && children.length > 0) {
            result = children[first ? 0 : children.length - 1];
            children = this.getSortedChildrenAsPreviewNodes(result);
        }
        return result;
    }

    private PreviewNode getElement(PreviewNode element, boolean next) {
        PreviewNode parent;
        while ((parent = element.getParent()) != null) {
            PreviewNode candidate = this.getSibling(this.getSortedChildrenAsPreviewNodes(parent), element, next);
            if (candidate != null) {
                return candidate;
            }
            element = parent;
        }
        return null;
    }

    private PreviewNode getSibling(PreviewNode[] children, PreviewNode element, boolean next) {
        int i = 0;
        while (i < children.length) {
            if (children[i] == element) {
                if (next) {
                    if (i < children.length - 1) {
                        return children[i + 1];
                    }
                    return null;
                }
                if (i > 0) {
                    return children[i - 1];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private PreviewNode[] getSortedChildrenAsPreviewNodes(PreviewNode parent) {
        Object[] sorted = this.getSortedChildren(parent);
        PreviewNode[] result = new PreviewNode[sorted.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (PreviewNode)sorted[i];
            ++i;
        }
        return result;
    }

    private static class DerivedFilter
    extends ViewerFilter {
        private DerivedFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !((PreviewNode)element).hasDerived();
        }
    }

    private static class GroupCategoryFilter
    extends ViewerFilter {
        private List fGroupCategories;

        private GroupCategoryFilter() {
        }

        public void setGroupCategory(List groupCategories) {
            this.fGroupCategories = groupCategories;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fGroupCategories == null) {
                return true;
            }
            return ((PreviewNode)element).hasOneGroupCategory(this.fGroupCategories);
        }
    }
}

