/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JreFindDialog;
import com.sun.deploy.panel.JreTableModel;
import com.sun.deploy.panel.PathEditor;
import com.sun.deploy.panel.PathRenderer;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.DialogTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JreDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener {
    private final JButton _findBtn = this.makeButton("deploy.jre.find.button");
    private final JButton _addBtn = this.makeButton("deploy.jre.add.button");
    private final JButton _removeBtn = this.makeButton("deploy.jre.remove.button");
    private final JButton _okBtn = new JButton(ResourceManager.getMessage("deploy.jre.ok.button"));
    private final JButton _cancelBtn;
    private final JreTableModel _sysTableModel;
    private final JreTableModel _userTableModel;
    private final JTabbedPane _tabbedPane;
    private final JTable _userTable;
    private final JTable _sysTable;
    private final JScrollPane _userTab;
    private final JScrollPane _systemTab;

    public JreDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this._okBtn.addActionListener(this);
        this._cancelBtn = new JButton(ResourceManager.getMessage("deploy.jre.cancel.button"));
        this._cancelBtn.addActionListener(this);
        this._tabbedPane = new JTabbedPane();
        this._userTableModel = new JreTableModel(false);
        this._userTable = new JreTable(this._userTableModel);
        this._sysTableModel = new JreTableModel(true);
        this._sysTable = new JreTable(this._sysTableModel);
        this._userTab = new JScrollPane(this._userTable);
        this._systemTab = new JScrollPane(this._sysTable);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(ResourceManager.getMessage("deploy.jre.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JreDialog.this.closeDialog();
            }
        });
        this._findBtn.setToolTipText(ResourceManager.getMessage("deploy.jre.find_btn.tooltip"));
        this._addBtn.setToolTipText(ResourceManager.getMessage("deploy.jre.add_btn.tooltip"));
        this._removeBtn.setToolTipText(ResourceManager.getMessage("deploy.jre.remove_btn.tooltip"));
        JButton[] jButtonArray = new JButton[]{this._findBtn, this._addBtn, this._removeBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(ResourceManager.getMessage("deploy.jre.versions")));
        Dimension dimension = new Dimension(500, 150);
        LineBorder lineBorder = new LineBorder(this._userTable.getForeground());
        this._userTable.setBorder(lineBorder);
        this._userTable.setPreferredScrollableViewportSize(dimension);
        this._sysTable.setBorder(lineBorder);
        this._sysTable.setPreferredScrollableViewportSize(dimension);
        this._tabbedPane.addTab(ResourceManager.getMessage("cert.dialog.user.level"), this._userTab);
        this._tabbedPane.addTab(ResourceManager.getMessage("cert.dialog.system.level"), this._systemTab);
        this._tabbedPane.setSelectedIndex(0);
        this._tabbedPane.addChangeListener(this);
        jPanel.add((Component)this._tabbedPane, "North");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this._findBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this._addBtn);
        box.add(Box.createHorizontalStrut(5));
        box.add(this._removeBtn);
        jPanel.add((Component)box, "South");
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 10, 5));
        JButton[] jButtonArray2 = new JButton[]{this._okBtn, this._cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray2);
        jPanel2.add(this._okBtn);
        jPanel2.add(this._cancelBtn);
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this._okBtn);
        this.enableButtons();
        this.pack();
        this._userTable.getSelectionModel().addListSelectionListener(this);
        this._userTable.getColumnModel().getColumn(3).setCellRenderer(new PathRenderer());
        this._userTable.getColumnModel().getColumn(3).setCellEditor(new PathEditor());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JreDialog.this.closeDialog();
            }
        });
        this._userTable.getTableHeader().setFocusable(false);
        this._sysTable.getTableHeader().setFocusable(false);
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(ResourceManager.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        jButton.addActionListener(this);
        return jButton;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        Component component = this._tabbedPane.getSelectedComponent();
        if (component != null) {
            if (component.equals(this._userTab)) {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < this._userTableModel.getRowCount(); ++i) {
                    if (!this._userTable.isRowSelected(i)) continue;
                    bl = true;
                    if (!this._userTableModel.getJRE(i).isRegistered()) continue;
                    bl2 = true;
                }
                this._removeBtn.setEnabled(bl && !bl2);
                this._findBtn.setEnabled(true);
                this._addBtn.setEnabled(true);
            } else {
                this._removeBtn.setEnabled(false);
                this._findBtn.setEnabled(false);
                this._addBtn.setEnabled(false);
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        JTable jTable = this.getSelectedTable();
        JreTableModel jreTableModel = (JreTableModel)jTable.getModel();
        if (jButton == this._findBtn) {
            this.findJREs();
        } else if (jButton == this._addBtn) {
            jreTableModel.add(new JREInfo(null, null, null, null, null, Config.getOSName(), Config.getOSArch(), true, false), false, true);
            int n = jreTableModel.getRowCount() - 1;
            jTable.requestFocus();
            jTable.setRowSelectionInterval(n, n);
        } else if (jButton == this._removeBtn) {
            jreTableModel.remove(this._userTable.getSelectedRows());
        } else if (jButton == this._okBtn) {
            this.apply();
            ControlPanel.propertyHasChanged();
            this.closeDialog();
        } else if (jButton == this._cancelBtn) {
            this.closeDialog();
        }
    }

    private JTable getSelectedTable() {
        return this._tabbedPane.getSelectedComponent() == this._userTab ? this._userTable : this._sysTable;
    }

    private void apply() {
        JTable[] jTableArray = new JTable[]{this._userTable, this._sysTable};
        for (int i = 0; i < jTableArray.length; ++i) {
            if (jTableArray[i].equals(this._userTable) && jTableArray[i].isEditing()) {
                jTableArray[i].getCellEditor().stopCellEditing();
            }
            JreTableModel jreTableModel = (JreTableModel)jTableArray[i].getModel();
            jreTableModel.validateAndSave();
        }
    }

    private void findJREs() {
        JTable jTable = this.getSelectedTable();
        JreTableModel jreTableModel = (JreTableModel)jTable.getModel();
        try {
            JREInfo[] jREInfoArray = JreFindDialog.search(this);
            if (jREInfoArray != null) {
                for (int i = 0; i < jREInfoArray.length; ++i) {
                    jreTableModel.add(jREInfoArray[i], true, true);
                }
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    static class JreTable
    extends JTable {
        private boolean _systemTable = false;
        private String[] columnToolTips = new String[]{ResourceManager.getMessage("jretable.platform.tooltip"), ResourceManager.getMessage("jretable.product.tooltip"), ResourceManager.getMessage("jretable.location.tooltip"), ResourceManager.getMessage("jretable.path.tooltip"), ResourceManager.getMessage("jretable.vmargs.tooltip"), ResourceManager.getMessage("jretable.enable.tooltip")};

        public JreTable(JreTableModel jreTableModel) {
            super(jreTableModel);
            this._systemTable = jreTableModel.isSystem();
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(60);
            tableColumnModel.getColumn(1).setPreferredWidth(60);
            tableColumnModel.getColumn(2).setPreferredWidth(80);
            tableColumnModel.getColumn(3).setPreferredWidth(120);
            tableColumnModel.getColumn(4).setPreferredWidth(120);
            tableColumnModel.getColumn(5).setPreferredWidth(50);
        }

        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Object var2_2 = null;
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    int n2 = this.columnModel.getColumn(n).getModelIndex();
                    return JreTable.this.columnToolTips[n2];
                }
            };
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            string = n3 == 2 || n3 == 4 ? (String)this.getValueAt(n, n2) : (n3 == 3 && this._systemTable ? (String)this.getValueAt(n, n2) : super.getToolTipText(mouseEvent));
            if ("".equals(string)) {
                return null;
            }
            return string;
        }
    }
}

