/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.utils.handlers;

import it.sogei.rcp.core.util.RCPHandlerUtil;
import it.sogei.rcp.ui.utils.VisualizzatoreDocumentiUtil;
import it.sogei.rcp.ui.utils.properties.Messages;
import it.sogei.rcp.ui.utils.views.VisualizzatoreDocumentiView;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class VisualizzaDocumentiHandler
extends AbstractHandler {
    private String URL_PARAMETER_ID = "it.sogei.rcp.ui.utils.commands.url";
    private String TITLE_PARAMETER_ID = "it.sogei.rcp.ui.utils.commands.title";
    private String CONVERT_TXT_PARAMETER_ID = "it.sogei.rcp.ui.utils.commands.convertTxt";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String url = event.getParameter(this.URL_PARAMETER_ID);
        LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)("Url file da visualizzare " + url));
        String title = event.getParameter(this.TITLE_PARAMETER_ID);
        LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)("Titolo Documento " + url));
        boolean convertTxt = new Boolean(event.getParameter(this.CONVERT_TXT_PARAMETER_ID));
        LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)("copnvertTXT " + convertTxt));
        if (url != null) {
            if (convertTxt) {
                url = this.convertTXT(url);
            }
            if (!Util.isWindows() && url.endsWith(".xml")) {
                LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)"Non win e XML file - il file verr\u00e0\u00a0 visualizzato tramite l'applicazione di default");
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "Visualizza XML File", url, "Visualizzazione documento: " + url);
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)("visualizzazione da Browser di " + url));
                    browser.openURL(new URL(url));
                }
                catch (PartInitException e) {
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore nell'apertura del documento " + url));
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore: " + e.getMessage()));
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore nell'apertura del documento " + url));
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore: " + e.getMessage()));
                    e.printStackTrace();
                }
            } else {
                try {
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)2, (String)"Il file \u00e8 visualizzato all'interno dell'applicazione");
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
                    VisualizzatoreDocumentiView visualizzatoreDocumentiView = (VisualizzatoreDocumentiView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("it.sogei.rcp.ui.utils.views.visualizzatoredocumentiview");
                    visualizzatoreDocumentiView.setTitle(title);
                    visualizzatoreDocumentiView.gotoURL(url);
                }
                catch (PartInitException e) {
                    LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore: " + e.getMessage()));
                    throw new ExecutionException(Messages.VisualizzatoreDocumentiUtil_errorOpeningVisual, (Throwable)e);
                }
            }
        } else {
            try {
                FileDialog fd = new FileDialog(RCPHandlerUtil.getShell(), 4096);
                String filepath = fd.open();
                if (filepath != null) {
                    URL filePathUrl = new URL("file", null, filepath);
                    LogUtil.log((String)"Visualizza Documenti", (int)1, (String)("Documento da visualizzare: " + filePathUrl.toString()));
                    VisualizzatoreDocumentiUtil.visualizzaDocumento(filePathUrl);
                }
            }
            catch (MalformedURLException e) {
                LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore nell'apertura del documento " + url));
                LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore: " + e.getMessage()));
                e.printStackTrace();
            }
            catch (Exception e) {
                LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore nell'apertura del documento " + url));
                LogUtil.log((String)"VisualizzaDocumentiHandler", (int)4, (String)("errore: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return null;
    }

    private String convertTXT(String filePath) {
        try {
            int len;
            URL fileURL = new URL(filePath);
            String filename = fileURL.getPath();
            File tempFile = File.createTempFile("tempFile", ".txt");
            File fin = new File(filename);
            FileInputStream in = new FileInputStream(fin);
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            URL tempurl = tempFile.toURI().toURL();
            return tempurl.toString();
        }
        catch (Exception e) {
            LogUtil.log((Object)((Object)this), (int)4, (String)"Impossibile convertire il file", (Throwable)e);
            return null;
        }
    }
}

