/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.preferences;

import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.entities.priv.EclipsePreferencePageTO;
import it.sogei.rcp.ui.preferences.entities.priv.PreferencePageTO;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.sogei.rcp.ui.preferences";
    public static final HashMap<String, String> preferenceMap = new HashMap();
    public static ArrayList<PreferencePageTO> preferencePageList = new ArrayList();
    public static ArrayList<PreferencePageTO> preferencePageContributionsList = new ArrayList();
    public static ArrayList<EclipsePreferencePageTO> eclipsePreferencePageList = new ArrayList();
    private static Activator plugin;
    public PreferenceManager preferenceManager = new PreferenceManager('/');
    public ScopedPreferenceStore preferenceStore;
    public ScopedPreferenceStore preferenceStoreInstance;
    public static String lastSelectedPage;
    public static boolean showGeneralPage;
    public static boolean showSecurityPage;
    public static boolean showApplicazioniPage;

    static {
        showGeneralPage = false;
        showSecurityPage = false;
        showApplicazioniPage = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.createPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void createPreferences() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(PLUGIN_ID);
        this.fillPreferenceList(extensions, null);
    }

    private void fillPreferenceList(IConfigurationElement[] extensions, PreferencePageTO parent) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            try {
                String elementName = element.getName();
                if (elementName.equals("preference")) {
                    String prefId = element.getAttribute("id");
                    String prefScope = element.getAttribute("scope");
                    ScopeEnum scope = ScopeEnum.DEFAULT;
                    IConfigurationElement[] children = element.getChildren();
                    PreferenceBean prefBean = new PreferenceBean();
                    prefBean.setPluginId(element.getContributor().getName());
                    prefBean.setPrefId(prefId);
                    if ("CONFIGURATION".equals(prefScope)) {
                        scope = ScopeEnum.CONFIGURATION;
                    } else if ("INSTANCE".equals(prefScope)) {
                        scope = ScopeEnum.INSTANCE;
                    }
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        String childName = child.getName();
                        if ("preferenceField".equals(childName)) {
                            child.getAttribute("id");
                            prefBean.setFieldId(child.getAttribute("id"));
                            PreferencesUtilRCP.setInitialPreferenceValue(scope, prefBean, child.getAttribute("value"));
                        }
                        ++j;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

