/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.ui.preferences;

import it.sogei.rcp.ui.preferences.Activator;
import it.sogei.rcp.ui.preferences.entities.PreferenceComboFieldBean;
import it.sogei.rcp.ui.preferences.entities.PreferenceFieldBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.entities.priv.EclipsePreferencePageTO;
import it.sogei.rcp.ui.preferences.entities.priv.PreferencePageTO;
import it.sogei.rcp.ui.preferences.interfaces.IPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class Startup
implements IStartup {
    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    Activator.getDefault().preferenceStore = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), Activator.getDefault().getBundle().getSymbolicName());
                    Activator.getDefault().preferenceStoreInstance = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), Activator.getDefault().getBundle().getSymbolicName());
                    Startup.this.createPreferencePages();
                }
            }
        });
    }

    private void createPreferencePages() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("it.sogei.rcp.ui.preferences");
        this.fillPreferenceList(extensions, null);
    }

    private void fillPreferenceList(IConfigurationElement[] extensions, PreferencePageTO parent) {
        int i = 0;
        while (i < extensions.length) {
            block12: {
                IConfigurationElement element = extensions[i];
                try {
                    String elementName = element.getName();
                    if (elementName.equals("preferencePage") || elementName.equals("preferencePageContribution")) {
                        String id = element.getAttribute("id");
                        String parentId = element.getAttribute("parentId");
                        try {
                            IPreferences preferenceClass = (IPreferences)element.createExecutableExtension("class");
                            PreferencePageTO prefPageTO = new PreferencePageTO();
                            prefPageTO.id = id;
                            prefPageTO.pluginId = element.getContributor().getName();
                            prefPageTO.parentId = parentId;
                            Activator.showGeneralPage = true;
                            if ("it.sogei.rcp.ui.preferences.page.security".equals(parentId)) {
                                Activator.showSecurityPage = true;
                            }
                            if ("it.sogei.rcp.ui.preferences.page.applicazioni".equals(parentId)) {
                                Activator.showApplicazioniPage = true;
                            }
                            prefPageTO.preferences = preferenceClass;
                            this.setDefaults(prefPageTO);
                            IConfigurationElement[] children = element.getChildren();
                            if (children != null && children.length > 0) {
                                this.fillPreferenceList(children, prefPageTO);
                            }
                            if (parent != null) {
                                parent.addChild(prefPageTO);
                                break block12;
                            }
                            if (elementName.equals("preferencePage")) {
                                Activator.preferencePageList.add(prefPageTO);
                                break block12;
                            }
                            Activator.preferencePageContributionsList.add(prefPageTO);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        break block12;
                    }
                    if (elementName.equals("eclipsePreferencePage")) {
                        EclipsePreferencePageTO eclipsePage = new EclipsePreferencePageTO();
                        eclipsePage.path = element.getAttribute("path");
                        eclipsePage.parentpath = element.getAttribute("parentPath");
                        eclipsePage.removeSubnodes = new Boolean(element.getAttribute("removeSubnodes"));
                        Activator.eclipsePreferencePageList.add(eclipsePage);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    private void setDefaults(PreferencePageTO prefPageTO) {
        ScopedPreferenceStore prefStore = prefPageTO.preferences.getScope() == ScopeEnum.INSTANCE ? Activator.getDefault().preferenceStoreInstance : Activator.getDefault().preferenceStore;
        PreferenceFieldBean[] fields = prefPageTO.preferences.getPreferenceFields();
        if (fields != null && fields.length != 0) {
            int i = 0;
            while (i < fields.length) {
                PreferenceFieldBean field = fields[i];
                if (field != null) {
                    String fieldId = String.valueOf(prefPageTO.pluginId) + "/" + prefPageTO.id + "/" + field.getFieldId();
                    if (field.getFieldDefaultValue() != null) {
                        prefStore.setDefault(fieldId, field.getFieldDefaultValue());
                    } else if (field.getFieldType() == PreferenceFieldBean.FieldTypeEnum.COMBO || field.getFieldType() == PreferenceFieldBean.FieldTypeEnum.RADIO) {
                        prefStore.setDefault(fieldId, ((PreferenceComboFieldBean)field).getRadioLabelAndValues()[0][1]);
                    }
                }
                ++i;
            }
        }
    }
}

