/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class EmbeddedJNLPValidation {
    private final LaunchDesc jnlp;
    private final URL codebase;

    public EmbeddedJNLPValidation(LaunchDesc launchDesc, URL uRL) {
        String string;
        if (uRL == null || launchDesc == null) {
            throw new IllegalArgumentException("Should have jnlp and derivedCodebase.");
        }
        if (uRL.getProtocol().equals("http") && ((string = uRL.getHost()) == null || string.length() == 0)) {
            throw new IllegalArgumentException("Bad derivedCodebase: " + uRL);
        }
        this.jnlp = launchDesc;
        this.codebase = uRL;
    }

    public void validate() {
        String string = this.getCodebase();
        if (string != null && string.trim().length() > 0) {
            throw new RuntimeException("Embbeded JNLP should not have non-empty codebase. Got: " + string);
        }
        String string2 = this.getHref();
        try {
            URL uRL = new URL(string2);
            throw new RuntimeException("Absolute href not allowed with embbedded JNLP: " + string2);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = new URL(this.codebase, string2);
                if (!URLUtil.sameBase((URL)this.codebase, (URL)uRL)) {
                    throw new RuntimeException("Invalid 'href' value in embedded JNLP: " + string2);
                }
            }
            catch (MalformedURLException malformedURLException2) {
                throw new RuntimeException("Invalid URL derived with href: " + string2, malformedURLException2);
            }
            return;
        }
    }

    private String getCodebase() {
        return XMLUtils.getAttribute(this.jnlp.getXmlNode(), "", "codebase");
    }

    private String getHref() {
        return XMLUtils.getAttribute(this.jnlp.getXmlNode(), "", "href");
    }
}

