/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.risorse.ModelloSet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class CodiceCatastaleModel
extends GericoModel {
    private static Vector elencoCC;
    private String valorePredefinito = "";
    static Hashtable elencoCodiciCatastali;
    static boolean info;

    public CodiceCatastaleModel(String code, String errorDescription, String fileTerr, boolean batch) throws IllegalArgumentException {
        super(code, errorDescription, 4);
        CodiceCatastaleModel.caricaInfo();
        this.setValorePredefinito();
    }

    private static void caricaInfo() {
        if (!info) {
            try {
                ModelloSet mSet = new ModelloSet("");
                elencoCC = mSet.getInformazioniModel("cc.ger");
                elencoCodiciCatastali = new Hashtable(8500);
                int i = 0;
                while (i < elencoCC.size()) {
                    elencoCodiciCatastali.put((String)elencoCC.elementAt(i), "CC_VALIDO");
                    ++i;
                }
                info = true;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("ModelloSet.getInformazioniModel(cc.ger)");
            }
        }
    }

    public String getValorePredefinito() {
        return this.valorePredefinito;
    }

    public boolean isValorePredefinito() {
        return this.getValue().trim().equals(this.valorePredefinito);
    }

    public void setValore(String s) throws ControlloFormaleException {
        try {
            if (s.trim().equals(this.valorePredefinito)) {
                this.valore = s;
            } else {
                boolean found = false;
                if (elencoCodiciCatastali.get(s.toUpperCase()) != null) {
                    found = true;
                    this.valore = s.toUpperCase();
                }
                if (!found) {
                    if (s.length() > this.length()) {
                        this.errore = "020";
                        this.gravitaErrore = "scarto";
                        throw new ControlloFormaleException(s);
                    }
                    this.errore = "012";
                    this.gravitaErrore = "scarto_confermabile";
                    throw new ControlloFormaleException(s);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(s);
        }
    }

    public void setValorePredefinito() {
        this.valore = this.valorePredefinito;
    }
}

