/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.InstanceResolverAnnotation;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WSWebServiceContext;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.SingletonResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

public abstract class InstanceResolver<T> {
    private static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.server");

    @NotNull
    public abstract T resolve(@NotNull Packet var1);

    public void postInvoke(@NotNull Packet packet, @NotNull T t) {
    }

    public void start(@NotNull WSWebServiceContext wSWebServiceContext, @NotNull WSEndpoint wSEndpoint) {
        this.start(wSWebServiceContext);
    }

    public void start(@NotNull WebServiceContext webServiceContext) {
    }

    public void dispose() {
    }

    public static <T> InstanceResolver<T> createSingleton(T t) {
        assert (t != null);
        InstanceResolver<?> instanceResolver = InstanceResolver.createFromInstanceResolverAnnotation(t.getClass());
        if (instanceResolver == null) {
            instanceResolver = new SingletonResolver(t);
        }
        return instanceResolver;
    }

    public static <T> InstanceResolver<T> createDefault(@NotNull Class<T> clazz, boolean bl) {
        return InstanceResolver.createDefault(clazz);
    }

    public static <T> InstanceResolver<T> createDefault(@NotNull Class<T> clazz) {
        InstanceResolver<T> instanceResolver = InstanceResolver.createFromInstanceResolverAnnotation(clazz);
        if (instanceResolver == null) {
            instanceResolver = new SingletonResolver<T>(InstanceResolver.createNewInstance(clazz));
        }
        return instanceResolver;
    }

    public static <T> InstanceResolver<T> createFromInstanceResolverAnnotation(@NotNull Class<T> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            InstanceResolverAnnotation instanceResolverAnnotation = annotation.annotationType().getAnnotation(InstanceResolverAnnotation.class);
            if (instanceResolverAnnotation == null) continue;
            Class<? extends InstanceResolver> clazz2 = instanceResolverAnnotation.value();
            try {
                return clazz2.getConstructor(Class.class).newInstance(clazz);
            }
            catch (InstantiationException instantiationException) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER(clazz2.getName(), annotation.annotationType(), clazz.getName()));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER(clazz2.getName(), annotation.annotationType(), clazz.getName()));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER(clazz2.getName(), annotation.annotationType(), clazz.getName()));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WebServiceException(ServerMessages.FAILED_TO_INSTANTIATE_INSTANCE_RESOLVER(clazz2.getName(), annotation.annotationType(), clazz.getName()));
            }
        }
        return null;
    }

    protected static <T> T createNewInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, instantiationException.getMessage(), instantiationException);
            throw new ServerRtException(WsservletMessages.ERROR_IMPLEMENTOR_FACTORY_NEW_INSTANCE_FAILED(clazz), new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, illegalAccessException.getMessage(), illegalAccessException);
            throw new ServerRtException(WsservletMessages.ERROR_IMPLEMENTOR_FACTORY_NEW_INSTANCE_FAILED(clazz), new Object[0]);
        }
    }

    @NotNull
    public Invoker createInvoker() {
        return new Invoker(){

            @Override
            public void start(@NotNull WSWebServiceContext wSWebServiceContext, @NotNull WSEndpoint wSEndpoint) {
                InstanceResolver.this.start(wSWebServiceContext, wSEndpoint);
            }

            @Override
            public void dispose() {
                InstanceResolver.this.dispose();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Packet packet, Method method, Object ... objectArray) throws InvocationTargetException, IllegalAccessException {
                Object t = InstanceResolver.this.resolve(packet);
                try {
                    Object object = method.invoke(t, objectArray);
                    return object;
                }
                finally {
                    InstanceResolver.this.postInvoke(packet, t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <U> U invokeProvider(@NotNull Packet packet, U u) {
                Object t = InstanceResolver.this.resolve(packet);
                try {
                    U u2 = ((Provider)t).invoke(u);
                    return u2;
                }
                finally {
                    InstanceResolver.this.postInvoke(packet, t);
                }
            }

            public String toString() {
                return "Default Invoker over " + InstanceResolver.this.toString();
            }
        };
    }
}

