/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import sun.invoke.WrapperInstance;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    public static <T> T asInterfaceInstance(final Class<T> clazz, final MethodHandle methodHandle) {
        final Method method = MethodHandleProxies.getSingleMethod(clazz);
        if (method == null) {
            throw new IllegalArgumentException("not a single-method interface: " + clazz.getName());
        }
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        MethodHandle methodHandle2 = methodHandle.asType(methodType);
        methodHandle2 = methodHandle2.asType(methodHandle2.type().changeReturnType(Object.class));
        final MethodHandle methodHandle3 = methodHandle2.asSpreader(Object[].class, methodType.parameterCount());
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, WrapperInstance.class}, new InvocationHandler(){

            private Object getArg(String string) {
                if (string == "getWrapperInstanceTarget") {
                    return methodHandle;
                }
                if (string == "getWrapperInstanceType") {
                    return clazz;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
                if (method2.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method2.getName());
                }
                if (method2.equals(method)) {
                    return methodHandle3.invokeExact(objectArray);
                }
                if (MethodHandleProxies.isObjectMethod(method2)) {
                    return MethodHandleProxies.callObjectMethod(this, method2, objectArray);
                }
                throw new InternalError();
            }
        }));
    }

    public static boolean isWrapperInstance(Object object) {
        return object instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object object) {
        try {
            if (object != null) {
                return (WrapperInstance)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                return method.getReturnType() == String.class && method.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
            }
            case "equals": {
                return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object object, Method method, Object[] objectArray) {
        assert (MethodHandleProxies.isObjectMethod(method)) : method;
        switch (method.getName()) {
            case "toString": {
                return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(object);
            }
            case "equals": {
                return object == objectArray[0];
            }
        }
        return null;
    }

    private static Method getSingleMethod(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return null;
        }
        Method method = null;
        for (Method method2 : clazz.getMethods()) {
            int n = method2.getModifiers();
            if (!Modifier.isAbstract(n)) continue;
            if (method != null && !MethodHandleProxies.isObjectMethod(method)) {
                return null;
            }
            method = method2;
        }
        return method;
    }
}

