/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state = 0;
    private Provider provider;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "MessageDigest", (String)null);
            if (objectArray[0] instanceof MessageDigest) {
                MessageDigest messageDigest = (MessageDigest)objectArray[0];
                messageDigest.provider = (Provider)objectArray[1];
                return messageDigest;
            }
            Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", string2);
        if (objectArray[0] instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)objectArray[0];
            messageDigest.provider = (Provider)objectArray[1];
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "MessageDigest", provider);
        if (objectArray[0] instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)objectArray[0];
            messageDigest.provider = (Provider)objectArray[1];
            return messageDigest;
        }
        Delegate delegate = new Delegate((MessageDigestSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
        this.state = 1;
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.engineUpdate(byArray, n, n2);
        this.state = 1;
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
        this.state = 1;
    }

    public final void update(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        this.engineUpdate(byteBuffer);
        this.state = 1;
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.state = 0;
        return byArray;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        if (byArray == null) {
            throw new IllegalArgumentException("No output buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Output buffer too small for specified offset and length");
        }
        int n3 = this.engineDigest(byArray, n, n2);
        this.state = 0;
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(this.algorithm + " Message Digest from " + this.provider.getName() + ", ");
        switch (this.state) {
            case 0: {
                printStream.print("<initialized>");
                break;
            }
            case 1: {
                printStream.print("<in progress>");
            }
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        int n = this.engineGetDigestLength();
        if (n == 0) {
            try {
                MessageDigest messageDigest = (MessageDigest)this.clone();
                byte[] byArray = messageDigest.digest();
                return byArray.length;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return n;
            }
        }
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    static class Delegate
    extends MessageDigest {
        private MessageDigestSpi digestSpi;

        public Delegate(MessageDigestSpi messageDigestSpi, String string) {
            super(string);
            this.digestSpi = messageDigestSpi;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (this.digestSpi instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)this.digestSpi.clone();
                Delegate delegate = new Delegate(messageDigestSpi, ((MessageDigest)this).algorithm);
                ((MessageDigest)delegate).provider = ((MessageDigest)this).provider;
                ((MessageDigest)delegate).state = ((MessageDigest)this).state;
                return delegate;
            }
            throw new CloneNotSupportedException();
        }

        @Override
        protected int engineGetDigestLength() {
            return this.digestSpi.engineGetDigestLength();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.digestSpi.engineUpdate(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.digestSpi.engineUpdate(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.digestSpi.engineUpdate(byteBuffer);
        }

        @Override
        protected byte[] engineDigest() {
            return this.digestSpi.engineDigest();
        }

        @Override
        protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
            return this.digestSpi.engineDigest(byArray, n, n2);
        }

        @Override
        protected void engineReset() {
            this.digestSpi.engineReset();
        }
    }
}

