/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.List;
import sun.org.mozilla.javascript.internal.Node;
import sun.org.mozilla.javascript.internal.Token;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.VariableInitializer;

public class VariableDeclaration
extends AstNode {
    private List<VariableInitializer> variables = new ArrayList<VariableInitializer>();

    public VariableDeclaration() {
        this.type = 122;
    }

    public VariableDeclaration(int n) {
        super(n);
        this.type = 122;
    }

    public VariableDeclaration(int n, int n2) {
        super(n, n2);
        this.type = 122;
    }

    public List<VariableInitializer> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableInitializer> list) {
        this.assertNotNull(list);
        this.variables.clear();
        for (VariableInitializer variableInitializer : list) {
            this.addVariable(variableInitializer);
        }
    }

    public void addVariable(VariableInitializer variableInitializer) {
        this.assertNotNull(variableInitializer);
        this.variables.add(variableInitializer);
        variableInitializer.setParent(this);
    }

    @Override
    public Node setType(int n) {
        if (n != 122 && n != 154 && n != 153) {
            throw new IllegalArgumentException("invalid decl type: " + n);
        }
        return super.setType(n);
    }

    public boolean isVar() {
        return this.type == 122;
    }

    public boolean isConst() {
        return this.type == 154;
    }

    public boolean isLet() {
        return this.type == 153;
    }

    private String declTypeName() {
        return Token.typeToName(this.type).toLowerCase();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.declTypeName());
        stringBuilder.append(" ");
        this.printList(this.variables, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (AstNode astNode : this.variables) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

