/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.p2.ui.dialogs.DelayedFilterCheckboxTree;
import org.eclipse.equinox.internal.p2.ui.dialogs.IPreFilterJobProvider;
import org.eclipse.equinox.internal.p2.ui.dialogs.StructuredIUGroup;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableIUGroup
extends StructuredIUGroup {
    public static final int AVAILABLE_ALL = 1;
    public static final int AVAILABLE_NONE = 2;
    public static final int AVAILABLE_LOCAL = 3;
    public static final int AVAILABLE_SPECIFIED = 4;
    IUViewQueryContext queryContext;
    int filterConstant = 1;
    URI repositoryFilter;
    QueryableMetadataRepositoryManager queryableManager;
    AvailableIUPatternFilter filter;
    private boolean useBold = false;
    private IUDetailsLabelProvider labelProvider;
    private int repoFlags;
    Display display;
    DelayedFilterCheckboxTree filteredTree;
    Job lastRequestedLoadJob;

    public AvailableIUGroup(ProvisioningUI ui, Composite parent) {
        this(ui, parent, parent.getFont(), null, AvailableIUGroup.getDefaultColumnConfig(), 1);
    }

    private static IUColumnConfig[] getDefaultColumnConfig() {
        IUColumnConfig nameColumn = new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 75);
        IUColumnConfig versionColumn = new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 40);
        return new IUColumnConfig[]{nameColumn, versionColumn};
    }

    public AvailableIUGroup(ProvisioningUI ui, Composite parent, Font font, IUViewQueryContext queryContext, IUColumnConfig[] columnConfig, int filterConstant) {
        super(ui, parent, font, columnConfig);
        this.display = parent.getDisplay();
        this.queryContext = queryContext == null ? ProvUI.getQueryContext(this.getPolicy()) : queryContext;
        this.repoFlags = ui.getRepositoryTracker().getMetadataRepositoryFlags();
        this.queryableManager = new QueryableMetadataRepositoryManager(ui, false);
        this.filterConstant = filterConstant;
        this.filter = new AvailableIUPatternFilter(this.getColumnConfig());
        this.filter.setIncludeLeadingWildcard(true);
        this.createGroupComposite(parent);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.filteredTree = new DelayedFilterCheckboxTree(parent, 68354, this.filter, this.getPreFilterJobProvider());
        TreeViewer availableIUViewer = this.filteredTree.getViewer();
        availableIUViewer.getTree().setFont(parent.getFont());
        this.filteredTree.getFilterControl().setFont(parent.getFont());
        availableIUViewer.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                AvailableIUGroup.this.lastRequestedLoadJob = null;
            }

            public void treeExpanded(TreeEvent e) {
                AvailableIUGroup.this.lastRequestedLoadJob = null;
            }
        });
        this.labelProvider = new IUDetailsLabelProvider(this.filteredTree, this.getColumnConfig(), this.getShell());
        this.labelProvider.setUseBoldFontForFilteredItems(this.useBold);
        this.labelProvider.setToolTipProperty("org.eclipse.equinox.p2.description");
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(this.getColumnConfig());
        availableIUViewer.setComparator((ViewerComparator)comparator);
        availableIUViewer.setComparer((IElementComparer)new ProvElementComparer());
        DeferredQueryContentProvider contentProvider = new DeferredQueryContentProvider();
        availableIUViewer.setContentProvider((IContentProvider)contentProvider);
        this.setTreeColumns(availableIUViewer.getTree());
        availableIUViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filteredTree.contentProviderSet(contentProvider);
        final StructuredViewerProvisioningListener listener = new StructuredViewerProvisioningListener(this.getClass().getName(), (StructuredViewer)availableIUViewer, 1, this.getProvisioningUI().getOperationRunner()){

            protected void repositoryAdded(RepositoryEvent event) {
                AvailableIUGroup.this.makeRepositoryVisible(event.getRepositoryLocation());
            }

            protected void refreshViewer() {
                TreeViewer treeViewer = AvailableIUGroup.this.filteredTree.getViewer();
                Tree tree = treeViewer.getTree();
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench.isClosing()) {
                    return;
                }
                if (tree != null && !tree.isDisposed()) {
                    AvailableIUGroup.this.updateAvailableViewState();
                }
            }
        };
        ProvUI.getProvisioningEventBus(this.getProvisioningUI().getSession()).addListener((ProvisioningListener)listener);
        availableIUViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProvUI.getProvisioningEventBus(AvailableIUGroup.this.getProvisioningUI().getSession()).removeListener((ProvisioningListener)listener);
            }
        });
        this.updateAvailableViewState();
        return availableIUViewer;
    }

    private void setTreeColumns(Tree tree) {
        tree.setHeaderVisible(true);
        IUColumnConfig[] cols = this.getColumnConfig();
        int i = 0;
        while (i < cols.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(cols[i].getColumnTitle());
            tc.setWidth(cols[i].getWidthInPixels((Control)tree));
            ++i;
        }
    }

    Object getNewInput() {
        if (this.repositoryFilter != null) {
            return new MetadataRepositoryElement(this.queryContext, this.getProvisioningUI(), this.repositoryFilter, true);
        }
        if (this.filterConstant == 2) {
            return new ProvElement(null){

                public Object[] getChildren(Object o) {
                    String description;
                    String name;
                    int severity;
                    if (!AvailableIUGroup.this.getPolicy().getRepositoriesVisible()) {
                        severity = 4;
                        name = ProvUIMessages.AvailableIUGroup_NoSitesConfiguredExplanation;
                        description = ProvUIMessages.AvailableIUGroup_NoSitesConfiguredDescription;
                    } else {
                        severity = 1;
                        name = ProvUIMessages.AvailableIUGroup_NoSitesExplanation;
                        description = ProvUIMessages.ColocatedRepositoryManipulator_NoContentExplanation;
                    }
                    return new Object[]{new EmptyElementExplanation(null, severity, name, description)};
                }

                public String getLabel(Object o) {
                    return null;
                }
            };
        }
        this.queryableManager.setRespositoryFlags(this.repoFlags);
        return new MetadataRepositories(this.queryContext, this.getProvisioningUI(), this.queryableManager);
    }

    public void setUseBoldFontForFilteredItems(boolean useBoldFont) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseBoldFontForFilteredItems(useBoldFont);
        }
    }

    @Override
    public Composite getComposite() {
        return super.getComposite();
    }

    @Override
    public StructuredViewer getStructuredViewer() {
        return super.getStructuredViewer();
    }

    @Override
    public List<IInstallableUnit> getSelectedIUs() {
        return super.getSelectedIUs();
    }

    @Override
    public Object[] getSelectedIUElements() {
        Object[] elements = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        ArrayList<Object> list = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (ElementUtils.getIU(elements[i]) != null) {
                list.add(elements[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.filteredTree.getCheckboxTreeViewer();
    }

    public IInstallableUnit[] getCheckedLeafIUs() {
        Object[] selections = this.filteredTree.getCheckedElements();
        if (selections.length == 0) {
            return new IInstallableUnit[0];
        }
        ArrayList<IInstallableUnit> leaves = new ArrayList<IInstallableUnit>(selections.length);
        int i = 0;
        while (i < selections.length) {
            IInstallableUnit iu;
            if (!(this.getCheckboxTreeViewer().getGrayed(selections[i]) || (iu = ProvUI.getAdapter(selections[i], IInstallableUnit.class)) == null || ProvUI.isCategory(iu) || leaves.contains(iu))) {
                leaves.add(iu);
            }
            ++i;
        }
        return leaves.toArray(new IInstallableUnit[leaves.size()]);
    }

    public Tree getTree() {
        if (this.viewer == null) {
            return null;
        }
        return ((TreeViewer)this.viewer).getTree();
    }

    void makeRepositoryVisible(final URI location) {
        if (this.queryContext.getViewType() != 2) {
            if (Display.getCurrent() == null) {
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        AvailableIUGroup.this.updateAvailableViewState();
                    }
                });
            } else {
                this.updateAvailableViewState();
            }
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                TreeViewer treeViewer = AvailableIUGroup.this.filteredTree.getViewer();
                Tree tree = treeViewer.getTree();
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench.isClosing()) {
                    return;
                }
                if (tree != null && !tree.isDisposed()) {
                    AvailableIUGroup.this.updateAvailableViewState();
                }
            }
        };
        if (Display.getCurrent() == null) {
            this.display.asyncExec(runnable);
        } else {
            runnable.run();
        }
        Job job = new Job(NLS.bind((String)ProvUIMessages.AvailableIUGroup_LoadingRepository, (Object)URIUtil.toUnencodedString((URI)location))){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AvailableIUGroup.this.getProvisioningUI().loadMetadataRepository(location, true, monitor);
                    return Status.OK_STATUS;
                }
                catch (ProvisionException e) {
                    return e.getStatus();
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    AvailableIUGroup.this.display.asyncExec(new Runnable(){

                        public void run() {
                            Tree tree;
                            TreeViewer treeViewer = (this).AvailableIUGroup.this.filteredTree.getViewer();
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            if (workbench.isClosing()) {
                                return;
                            }
                            if (event.getJob() == (this).AvailableIUGroup.this.lastRequestedLoadJob && (tree = treeViewer.getTree()) != null && !tree.isDisposed()) {
                                TreeItem[] items = tree.getItems();
                                int i = 0;
                                while (i < items.length) {
                                    URI url;
                                    if (items[i].getData() instanceof IRepositoryElement && (url = ((IRepositoryElement)items[i].getData()).getLocation()).equals(location)) {
                                        treeViewer.expandToLevel(items[i].getData(), -1);
                                        tree.select(items[i]);
                                        return;
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                }
            }
        });
        this.lastRequestedLoadJob = job;
        job.schedule();
    }

    public void updateAvailableViewState() {
        if (this.getTree() == null || this.getTree().isDisposed()) {
            return;
        }
        final Composite parent = this.getComposite().getParent();
        this.setUseBoldFontForFilteredItems(this.queryContext.getViewType() != 3);
        BusyIndicator.showWhile((Display)this.display, (Runnable)new Runnable(){

            public void run() {
                parent.setRedraw(false);
                AvailableIUGroup.this.getCheckboxTreeViewer().setInput(AvailableIUGroup.this.getNewInput());
                parent.layout(true);
                parent.setRedraw(true);
            }
        });
    }

    @Override
    public Control getDefaultFocusControl() {
        if (this.filteredTree != null) {
            return this.filteredTree.getFilterControl();
        }
        return null;
    }

    @Override
    protected GridData getViewerGridData() {
        GridData data = super.getViewerGridData();
        data.heightHint = this.convertHeightInCharsToPixels(10);
        return data;
    }

    public void setChecked(Object[] selections) {
        this.filteredTree.getCheckboxTreeViewer().setCheckedElements(selections);
        Object element = selections.length == 0 ? DelayedFilterCheckboxTree.ALL_ITEMS_HACK : selections[0];
        this.filteredTree.getCheckboxTreeViewer().fireCheckStateChanged(element, selections.length > 0);
    }

    public void setRepositoryFilter(int filterFlag, URI repoLocation) {
        if (this.filterConstant == filterFlag) {
            if (this.filterConstant != 4) {
                return;
            }
            if (repoLocation != null && repoLocation.equals(this.repositoryFilter)) {
                return;
            }
        }
        this.filterConstant = filterFlag;
        switch (filterFlag) {
            case 1: 
            case 2: {
                this.repositoryFilter = null;
                this.repoFlags &= 0xFFFFFFFB;
                break;
            }
            case 3: {
                this.repositoryFilter = null;
                this.repoFlags |= 4;
                break;
            }
            default: {
                this.repositoryFilter = repoLocation;
            }
        }
        this.updateAvailableViewState();
        this.filteredTree.clearCheckStateCache();
    }

    private IPreFilterJobProvider getPreFilterJobProvider() {
        return new IPreFilterJobProvider(){

            public Job getPreFilterJob() {
                switch (AvailableIUGroup.this.filterConstant) {
                    case 1: {
                        LoadMetadataRepositoryJob preFilterJob = new LoadMetadataRepositoryJob(AvailableIUGroup.this.getProvisioningUI());
                        preFilterJob.setProperty(LoadMetadataRepositoryJob.SUPPRESS_REPOSITORY_EVENTS, Boolean.toString(true));
                        return preFilterJob;
                    }
                    case 2: 
                    case 3: {
                        return null;
                    }
                }
                if (AvailableIUGroup.this.repositoryFilter == null) {
                    return null;
                }
                Job job = new Job("Repository Load Job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            AvailableIUGroup.this.getProvisioningUI().loadMetadataRepository((this).AvailableIUGroup.this.repositoryFilter, false, monitor);
                            return Status.OK_STATUS;
                        }
                        catch (ProvisionException e) {
                            return e.getStatus();
                        }
                    }
                };
                job.setPriority(20);
                return job;
            }
        };
    }
}

