/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.dsa.DSAParams;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.DSAPublicKeySpec;

public class DSAPublicKey
extends PublicKeyInfo
implements Serializable,
java.security.interfaces.DSAPublicKey {
    private DSAParams c;
    private BigInteger a;
    private transient ASN1 b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DSA public key");
        stringBuffer.append(this.c == null ? ":\n" : " (" + this.c.getP().bitLength() + " bits):\n");
        stringBuffer.append("y: " + this.a.toString(16) + "\n");
        if (this.c != null) {
            stringBuffer.append(this.c.toString());
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.c.hashCode() ^ this.a.hashCode();
    }

    public BigInteger getY() {
        return this.a;
    }

    public java.security.interfaces.DSAParams getParams() {
        return this.c;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
            if (!this.a.equals(dSAPublicKey.getY())) {
                return false;
            }
            return this.c.equals(dSAPublicKey.getParams());
        }
        return false;
    }

    public byte[] encode() {
        return this.b.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a = (BigInteger)this.b.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                this.c = new DSAParams(aSN1Object);
                return;
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DSA public key.");
        }
    }

    private void a() {
        try {
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.dsa.clone();
            if (this.c != null) {
                this.public_key_algorithm.setParameter(this.c.toASN1Object());
            } else {
                this.public_key_algorithm.encodeAbsentParametersAsNull(false);
            }
            this.b = new ASN1(new INTEGER(this.a));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DSAPublicKey(DSAPublicKeySpec dSAPublicKeySpec) {
        this(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
    }

    public DSAPublicKey(java.security.interfaces.DSAPublicKey dSAPublicKey) {
        this(dSAPublicKey.getY(), dSAPublicKey.getParams());
    }

    public DSAPublicKey(BigInteger bigInteger, java.security.interfaces.DSAParams dSAParams) {
        this.a = bigInteger;
        if (dSAParams != null) {
            this.c = new DSAParams(dSAParams);
        }
        this.a();
    }

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.a = bigInteger;
        this.c = new DSAParams(bigInteger2, bigInteger3, bigInteger4);
        this.a();
    }

    public DSAPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public DSAPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

