/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.enc.KeySizeImpl;
import iaik.xml.crypto.utils.Nodes;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionMethodImpl
extends AlgorithmMethodImpl
implements EncryptionMethod {
    static /* synthetic */ Class class$javax$xml$crypto$enc$spec$EncryptionMethodParameterSpec;
    protected KeySizeImpl keySize_;
    protected Cipher cipher_;

    public byte[] wrapKey(Key key, Key key2) throws XMLEncryptionException {
        try {
            this.cipher_.init(3, key, this.spec_);
            return this.cipher_.wrap(key2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException(illegalStateException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new XMLEncryptionException(illegalBlockSizeException);
        }
    }

    public Key unwrapKey(Key key, byte[] byArray, String string, int n) throws XMLEncryptionException {
        try {
            this.cipher_.init(4, key, this.spec_);
            return this.cipher_.unwrap(byArray, string, n);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new XMLEncryptionException(illegalStateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLEncryptionException(noSuchAlgorithmException);
        }
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && "KeySize".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI())) {
                DOMStructure dOMStructure = DOMStructure.getInstance(node, dOMCryptoContext);
                if (dOMStructure != null) {
                    this.putChildStructure(dOMStructure);
                }
            } else {
                arrayList.add(node);
            }
            ++n;
        }
        super.unmarshalStructures(Nodes.nodeList(arrayList), dOMCryptoContext);
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof KeySizeImpl) {
            this.keySize_ = (KeySizeImpl)dOMStructure;
        }
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public String getLocalName() {
        return "EncryptionMethod";
    }

    public Integer getKeySize() {
        return this.keySize_ != null ? new Integer(this.keySize_.getKeySize()) : null;
    }

    protected List getChildStructures() {
        ArrayList<KeySizeImpl> arrayList = new ArrayList<KeySizeImpl>();
        if (this.keySize_ != null) {
            arrayList.add(this.keySize_);
        }
        arrayList.addAll(super.getChildStructures());
        return arrayList;
    }

    public OutputStream encrypt(Key key, OutputStream outputStream) throws XMLEncryptionException {
        try {
            this.cipher_.init(1, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherOutputStream(outputStream, this.cipher_);
    }

    public InputStream encrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        try {
            this.cipher_.init(1, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherInputStream(inputStream, this.cipher_);
    }

    public InputStream decrypt(Key key, InputStream inputStream) throws XMLEncryptionException {
        try {
            this.cipher_.init(2, key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLEncryptionException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLEncryptionException(invalidAlgorithmParameterException);
        }
        return new CipherInputStream(inputStream, this.cipher_);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EncryptionMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.algorithm_ == null) {
            throw new MarshalException("The content of element '" + node.getLocalName() + "' is not complete.");
        }
        String string = URLEncoder.encode(this.algorithm_.toString());
        try {
            this.cipher_ = Cipher.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new MarshalException(noSuchPaddingException);
        }
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(class$javax$xml$crypto$enc$spec$EncryptionMethodParameterSpec != null ? class$javax$xml$crypto$enc$spec$EncryptionMethodParameterSpec : (class$javax$xml$crypto$enc$spec$EncryptionMethodParameterSpec = EncryptionMethodImpl.class$("javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new MarshalException(invalidParameterSpecException);
            }
        }
    }

    public EncryptionMethodImpl(String string, Integer n, EncryptionMethodParameterSpec encryptionMethodParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(string, encryptionMethodParameterSpec);
        if (n != null) {
            this.keySize_ = new KeySizeImpl(n);
        }
        String string2 = URLEncoder.encode(string.toString());
        try {
            this.cipher_ = Cipher.getInstance(string2);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException(noSuchPaddingException.getMessage());
        }
    }
}

