/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.deploy.config.Platform;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.VersionID;
import java.util.Map;
import sun.plugin2.main.server.JVMInstance;
import sun.plugin2.util.SystemUtil;

public class ClientJVMSelectionParameters {
    static final VersionID DEFAULT_FX_VERSION = new VersionID("2.0+");
    private static boolean DEBUG = SystemUtil.isDebug();
    private static boolean VERBOSE = SystemUtil.isVerbose();
    private boolean separateJVM;
    private long availableHeapSize = -1L;
    private VersionID needFx = null;
    private boolean useJfxToolkit = false;

    public static ClientJVMSelectionParameters getDefault() {
        return new ClientJVMSelectionParameters();
    }

    public void setAvailableHeapSize(long l) {
        this.availableHeapSize = l;
    }

    public void setSeparateJVM(boolean bl) {
        this.separateJVM = bl;
    }

    public void setJfxRequirement(String string) {
        this.needFx = string == null ? null : ((string = string.trim()).length() == 0 ? DEFAULT_FX_VERSION : new VersionID(string));
    }

    public VersionID getJfxRequirement() {
        return this.needFx;
    }

    public boolean useJfxToolkit() {
        return this.useJfxToolkit;
    }

    public static ClientJVMSelectionParameters extract(Map map) {
        String string;
        ClientJVMSelectionParameters clientJVMSelectionParameters;
        block6: {
            clientJVMSelectionParameters = new ClientJVMSelectionParameters();
            clientJVMSelectionParameters.separateJVM = ClientJVMSelectionParameters.extractBoolean("separate_jvm", map);
            clientJVMSelectionParameters.availableHeapSize = -1L;
            string = (String)map.get("java_required_heap");
            if (string != null) {
                try {
                    clientJVMSelectionParameters.availableHeapSize = JVMParameters.parseMemorySpec((String)string);
                }
                catch (Exception exception) {
                    if (!DEBUG) break block6;
                    System.out.println("WARNING: no JVM heap size restriction will be applieddue to invalid 'java_required_heap' value: " + string);
                    System.out.println(", exception: " + exception.getLocalizedMessage());
                }
            }
        }
        clientJVMSelectionParameters.setJfxRequirement((String)map.get("javafx_version"));
        if (clientJVMSelectionParameters.getJfxRequirement() != null) {
            string = (String)map.get("__ui_tk");
            if (string == null) {
                clientJVMSelectionParameters.useJfxToolkit = true;
            } else {
                string = string.trim();
                clientJVMSelectionParameters.useJfxToolkit = string.equalsIgnoreCase("jfx");
            }
        }
        return clientJVMSelectionParameters;
    }

    public long getAvailableHeapSize() {
        return this.availableHeapSize;
    }

    public boolean isSeparateJVM() {
        return this.separateJVM;
    }

    private static boolean extractBoolean(String string, Map map) {
        boolean bl = false;
        String string2 = (String)map.get(string);
        if (string2 != null) {
            bl = Boolean.valueOf(string2);
        }
        return bl;
    }

    public boolean match(JVMInstance jVMInstance) {
        boolean bl = false;
        if (this.availableHeapSize < 0L || jVMInstance.getAvailableHeapSize() < 0L) {
            bl = true;
        }
        if (!bl && this.availableHeapSize <= jVMInstance.getAvailableHeapSize()) {
            bl = true;
        }
        boolean bl2 = Platform.get().isJavaFXEnabled();
        VersionID versionID = null;
        if (bl2) {
            versionID = jVMInstance.getJfxAvailability();
            if (bl) {
                if (this.needFx == null) {
                    bl = null == versionID;
                } else {
                    boolean bl3 = bl = versionID == null ? Platform.get().getInstalledJfxRuntimes().isEmpty() : this.needFx.match(versionID);
                }
            }
            if (bl) {
                boolean bl4 = bl = jVMInstance.isJfxToolkit() == this.useJfxToolkit;
            }
        }
        if (DEBUG && VERBOSE) {
            String string = "ClientJVMSelectionParameters matched=" + bl;
            string = string + " required availableHeapSize=" + this.availableHeapSize + "\n";
            String string2 = this.needFx == null ? "none" : this.needFx.toString();
            string = string + "  require FX version: " + string2 + "\n";
            if (bl2) {
                string2 = versionID == null ? "none" : versionID.toString();
                string = string + "  detected FX version: " + string2 + "\n";
            } else {
                string = string + "  JavaFX runtime is disabled.\n";
            }
            string = string + "  need " + (this.useJfxToolkit ? "FX" : "AWT") + " toolkit\n";
            string = string + "  has " + (jVMInstance.isJfxToolkit() ? "FX" : "AWT") + " toolkit\n";
            System.out.println(string);
        }
        return bl;
    }
}

