/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.BASE64Decoder;
import sun.plugin2.os.windows.OSVERSIONINFOA;
import sun.plugin2.os.windows.Windows;

public class SystemUtil {
    private static String javaHome;
    private static volatile boolean getenvSupported;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int MACOSX = 3;
    private static int osType;
    private static boolean isVista;

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = SystemUtil.getSystemProperty("java.home");
        }
        return javaHome;
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean debug(String string) {
        return SystemUtil.getSystemProperty("sun.plugin2.debug." + string) != null;
    }

    public static String getenv(final String string) {
        if (getenvSupported) {
            try {
                return (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getenv(string);
                    }
                });
            }
            catch (Error error) {
                getenvSupported = false;
            }
        }
        return null;
    }

    private static void computeIsVista() {
        OSVERSIONINFOA oSVERSIONINFOA = OSVERSIONINFOA.create();
        oSVERSIONINFOA.dwOSVersionInfoSize(OSVERSIONINFOA.size());
        if (Windows.GetVersionExA(oSVERSIONINFOA)) {
            isVista = oSVERSIONINFOA.dwPlatformId() == 2 && oSVERSIONINFOA.dwMajorVersion() >= 6;
        }
    }

    public static int getOSType() {
        if (osType == 0) {
            String string = SystemUtil.getSystemProperty("os.name").toLowerCase();
            if (string.startsWith("windows")) {
                osType = 1;
                SystemUtil.computeIsVista();
            } else {
                osType = string.startsWith("mac os x") ? 3 : 2;
            }
        }
        return osType;
    }

    public static boolean isWindowsVista() {
        SystemUtil.getOSType();
        return isVista;
    }

    public static String formatNativeLibraryName(String string) {
        switch (SystemUtil.getOSType()) {
            case 1: {
                return string + ".dll";
            }
            case 2: {
                return "lib" + string + ".so";
            }
            case 3: {
                return "lib" + string + ".jnilib";
            }
        }
        throw new InternalError("Unknown OS type");
    }

    public static String formatExecutableName(String string) {
        if (SystemUtil.getOSType() == 1) {
            return string + ".exe";
        }
        return string;
    }

    public static boolean isDebug() {
        return SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    }

    public static boolean isVerbose() {
        return SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    }

    public static byte[] decodeBase64(String string) {
        if (string == null) {
            return null;
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        try {
            return bASE64Decoder.decodeBuffer(string);
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
    }

    static {
        getenvSupported = true;
    }
}

