/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2015;

import finanze.IDTE.generale2015.BaseTelem;
import finanze.IDTE.generale2015.MainException;
import finanze.IDTE.generale2015.MainUnico;
import finanze.IDTE.generale2015.Util;
import finanze.IDTE.utility.QSortAlgorithm2;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class Visual {
    protected String rigaString = new String();
    protected BufferedWriter bufferedOutput;
    protected String modello = new String();
    protected boolean isWeb = false;
    public static final int IN_LENGTH = 106;
    public static final int MSG_LENGTH = 40;
    public static final int PAGE_WIDTH = 80;

    protected void addLegendaErrori() throws IOException {
        if (this.modello.substring(0, 3).equals("INP")) {
            this.writeRecLine("\n\n ---------------------------------------------------------------------- \n|                   --Descrizione degli errori--                       |\n|                                                                      |\n|(****) Errore che determina lo scarto dell'intera fornitura           |\n|(***)  Errore bloccante che determina lo scarto della denuncia        |\n|(*)    Segnalazione di anomalia di entit\u00e0 minore rispetto alle        |\n|       precedenti o di situazione particolare,lasciando quindi        |\n|       all'utente la facolt\u00e0 di verificare l'effettivo                |\n|       ricorrere di tali fattispecie.                                 |\n|                                                                      |\n|L'individuazione dei campi segnalati pu\u00f2 avvenire in alternativa:     |\n|                                                                      |\n|  .  con una descrizione puntuale del campo (ad es. per i dati        |\n|     anagrafici del dichiarante)                                      |\n|  .  con l'indicazione del quadro, del rigo e della colonna relativi  |\n|     al campo stesso.                                                 |\n|                                                                      |\n| ---------------------------------------------------------------------|\n| ----------         A  T  T  E  N  Z  I  O  N  E            ----------|\n| ---------------------------------------------------------------------|\n|                                                                      |\n| La procedura di controllo produce un file che schematizza i dati     |\n| calcolati e dichiarati dei prospetti Z1 e Z3 di riepilogo.           |\n| Il file viene salvato nella stessa directory del file di input ed \u00e8  |\n| identificato come  <nome file input>.schema.wri                      |\n|                                                                      |\n ---------------------------------------------------------------------- \n\n", false);
        } else {
            this.writeRecLine("\n\n ---------------------------------------------------------------------- \n|                   --Descrizione degli errori--                       |\n|                                                                      |\n|(****) Errore che determina lo scarto dell'intera fornitura           |\n|(***)  Errore bloccante che determina lo scarto della dichiarazione.  |\n|       Tale anomalia non consente in ogni caso la trasmissione della  |\n|       dichiarazione                                                  |\n|(***C) Errore di entit\u00e0 rilevante che determina lo scarto della       |\n|       dichiarazione. Qualora, in presenza di tali segnalazioni, si   |\n|       intenda comunque procedere alla trasmissione della             |\n|       dichiarazione, \u00e8 necessario confermare i dati in essa          |\n|       contenuti, avvalendosi delle funzionalit\u00e0 rese disponibili dal |\n|       software utilizzato per la compilazione. Con la 'conferma' si  |\n|       attesta di aver preso visione delle segnalazioni evidenziate   |\n|(**E)  Errore rilevante (solo mod. 730) che determina l'esclusione    |\n|       dall'assistenza fiscale                                        |\n|(**)   Segnalazione a fronte della quale \u00e8 stata richiesta la         |\n|       'conferma' della dichiarazione - vedi errori tipo (***C)       |\n|(*)    Segnalazione di anomalia di entit\u00e0 ridotta in presenza della   |\n|       quale la dichiarazione pu\u00f2 essere comunque trasmessa           |\n|                                                                      |\n|L'individuazione dei campi segnalati pu\u00f2 avvenire in alternativa:     |\n|                                                                      |\n|  .  con una descrizione puntuale del campo (ad es. per i dati        |\n|     anagrafici del dichiarante)                                      |\n|  .  con l'indicazione del quadro, del rigo e della colonna relativi  |\n|     al campo stesso.                                                 |\n|                                                                      |\n ---------------------------------------------------------------------- \n\n", false);
        }
    }

    protected int addTitolo(String codFmem, String CFbianco) throws IOException {
        int fl_CF = 1;
        String codF = this.rigaString.substring(1, 17);
        String campo = this.rigaString.substring(23, 26);
        if (codF.equals("0000000000000000")) {
            this.writeRecLine("\nPresenza di segnalazioni relative alla fornitura.");
            fl_CF = 0;
        }
        if (codF.substring(0, 9).equals("FORNITURA")) {
            this.writeRecLine("\nPresenza di segnalazioni relative alla fornitura.");
            if (!codF.substring(9, 16).trim().equals("0")) {
                this.writeRecLine("\nElaborazione interrotta al record " + codF.substring(9, 16).trim() + " dell'archivio di input.\n");
            } else {
                this.writeRecLine("\nElaborazione interrotta.\n");
            }
            fl_CF = 0;
        }
        if (codF.equals("9999999999999999")) {
            if (!codFmem.equals("ZZZZZZZZZZZZZZZZ")) {
                this.writeRecLine("\n==================Fine elaborazione dichiarazioni===================");
            }
            this.writeRecLine("\nPresenza di segnalazioni relative alla fornitura.");
            this.writeRecLine("\n\nIl file di Output delle dichiarazioni non e' stato prodotto.");
            fl_CF = 0;
        }
        if (codF.equals("AAAAAAAAAAAAAAAA") && (campo.equals("XXA") || campo.equals("   "))) {
            this.writeRecLine("\nPresenza di segnalazioni relative al Record tipo A.\n");
            fl_CF = 0;
        }
        if (codF.equals("ZZZZZZZZZZZZZZZZ") && (campo.equals("XXZ") || campo.equals("   "))) {
            this.writeRecLine("\n==================Fine elaborazione dichiarazioni===================\n");
            this.writeRecLine("Presenza di segnalazioni relative al Record tipo Z.\n");
            fl_CF = 0;
        }
        if (codF.substring(0, 15).equals("               ")) {
            fl_CF = 2;
        }
        if (fl_CF == 1) {
            this.writeRecLine("\n====================================================================");
            if (codFmem.substring(0, 15).equals("               ") && CFbianco.equals(codF)) {
                this.writeRecLine("              Dichiarazione numero " + codFmem.substring(15, 16) + " relativa a: " + codF);
            } else {
                this.writeRecLine("              Dichiarazione relativa a: " + codF + "\n");
            }
        }
        return fl_CF;
    }

    protected void coda() throws IOException {
        String stringaDich = Util.formStr(37, "", 'R');
        String stringaScartate = Util.formStr(37, "", 'R');
        String stringaNoRisp = Util.formStr(37, "", 'R');
        String stringaNoAssistenza = Util.formStr(37, "", 'R');
        String stringaConfermate = Util.formStr(37, "", 'R');
        String stringaSegnalate = Util.formStr(37, "", 'R');
        String stringaCorrette = Util.formStr(37, "", 'R');
        if (this.rigaString.substring(43, 49).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(43, 49).trim()) != 0) {
            stringaDich = " (" + this.rigaString.substring(43, 49).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(49, 55).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(49, 55).trim()) != 0) {
            stringaCorrette = " (" + this.rigaString.substring(49, 55).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(55, 61).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(55, 61).trim()) != 0) {
            stringaSegnalate = " (" + this.rigaString.substring(55, 61).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(61, 67).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(61, 67).trim()) != 0) {
            stringaConfermate = " (" + this.rigaString.substring(61, 67).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(67, 73).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(67, 73).trim()) != 0) {
            stringaNoAssistenza = " (" + this.rigaString.substring(67, 73).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(73, 79).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(73, 79).trim()) != 0) {
            stringaNoRisp = " (" + this.rigaString.substring(73, 79).trim() + " dichiarazioni congiunte)";
        }
        if (this.rigaString.substring(79, 85).trim().length() != 0 && Integer.parseInt(this.rigaString.substring(79, 85).trim()) != 0) {
            stringaScartate = " (" + this.rigaString.substring(79, 85).trim() + " dichiarazioni congiunte)";
        }
        String err730 = "";
        if (this.modello.substring(0, 3).equals("730")) {
            err730 = "*   escluse dall'assistenza      :" + this.rigaString.substring(25, 31) + Util.formStr(37, stringaNoAssistenza, 'R') + "*\n";
        }
        if (this.rigaString.substring(85, 86).equals(String.valueOf(1))) {
            this.writeRecLine("\nN.B. L'archivio sottoposto a controllo pu\u00f2 essere trasmesso esclusivamente avvalendosi del servizio telematico Entratel");
        }
        String coda = "\n\n******************************************************************************\n*                                  RIEPILOGO                                 *\n*                                                                            *\n* Totale dichiarazioni elaborate :" + this.rigaString.substring(1, 7) + Util.formStr(37, stringaDich, 'R') + "*\n* di cui:                                                                    *\n*   scartate per errori bloccanti:" + this.rigaString.substring(37, 43) + Util.formStr(37, stringaScartate, 'R') + "*\n*   scartate per non rispondenza :" + this.rigaString.substring(31, 37) + Util.formStr(37, stringaNoRisp, 'R') + "*\n" + err730 + "*   con errori confermati        :" + this.rigaString.substring(19, 25) + Util.formStr(37, stringaConfermate, 'R') + "*\n*   con segnalazione di anomalia :" + this.rigaString.substring(13, 19) + Util.formStr(37, stringaSegnalate, 'R') + "*\n*   senza segnalazioni           :" + this.rigaString.substring(7, 13) + Util.formStr(37, stringaCorrette, 'R') + "*\n*                                                                            *\n******************************************************************************\n";
        this.writeRecLine(coda, false);
    }

    public String decodificaAssistenza(boolean hideField) {
        String messaggioAssistenza = "";
        String appogen = "";
        String coderr = this.rigaString.substring(19, 23);
        int coderrInt = Util.valoreInt(coderr);
        int varComb = 0;
        String descErr = this.getDescrizione(coderr);
        String campo = this.rigaString.substring(23, 39);
        String quadro = campo.substring(0, 2);
        String rig = campo.substring(2, 5);
        String col = campo.substring(5, 8);
        String mod = campo.substring(8, campo.length()).trim();
        String dich = this.rigaString.substring(39, 55).trim();
        String calc = this.rigaString.substring(55, 71).trim();
        String calc2 = this.rigaString.substring(71, 84).trim();
        String CFperc = this.rigaString.substring(84, 100).trim();
        if (!descErr.equals("")) {
            if (quadro.equals("  ")) {
                messaggioAssistenza = descErr;
            } else if (quadro.equals("MM")) {
                String appo1 = mod;
                messaggioAssistenza = descErr + appo1;
            } else if (quadro.equals("XX")) {
                String appo1 = campo.substring(2, 5);
                messaggioAssistenza = this.getDescrizione(appo1) + " - " + this.getDescrizione(coderr);
            } else {
                String appoperc = "";
                if (!CFperc.equals("") && !CFperc.equals("0")) {
                    appoperc = " - Codice fiscale " + (this.modello.substring(0, 3).equals("INP") ? "iscritto " : "percipiente: ") + CFperc;
                }
                String dich3 = "";
                String calc3 = "";
                dich3 = dich.length() > 8 ? dich.substring(0, 8) : dich;
                String string = calc3 = calc.length() > 8 ? calc.substring(0, 8) : calc;
                if (1080 <= coderrInt && coderrInt <= 1084) {
                    dich3 = this.getDescrizione(dich3).trim().equals("") ? "Campo " + dich3 : this.getDescrizione(dich3);
                    calc3 = this.getDescrizione(calc3).trim().equals("") ? "campo " + calc3 : this.getDescrizione(calc3);
                    appogen = dich3 + " " + descErr + " " + calc3;
                } else {
                    if (hideField) {
                        varComb = 0;
                    } else {
                        if (!rig.equals("   ")) {
                            ++varComb;
                        }
                        if (!col.equals("   ")) {
                            varComb += 2;
                        }
                        if (!mod.equals("")) {
                            varComb += 4;
                        }
                    }
                    switch (varComb) {
                        case 0: {
                            appogen = descErr;
                            break;
                        }
                        case 1: {
                            appogen = "Rigo " + rig + " - " + descErr;
                            break;
                        }
                        case 3: {
                            String cod = this.getDescrizione(campo);
                            if (cod.trim().equals("")) {
                                cod = "Rigo " + rig + " Colonna " + col;
                            }
                            appogen = cod + " - " + descErr;
                            break;
                        }
                        case 4: {
                            appogen = descErr;
                            break;
                        }
                        case 5: {
                            appogen = "Rigo " + rig + " - " + descErr;
                            break;
                        }
                        case 7: {
                            String codice = this.getDescrizione(campo.substring(0, 8));
                            if (codice.trim().equals("") && (codice = this.getDescrizione(campo.substring(0, 2) + "XXX" + campo.substring(5, 8))).trim().equals("")) {
                                codice = "Codice " + quadro + " " + rig + " " + col + " ";
                            }
                            appogen = codice + " - " + descErr;
                        }
                    }
                }
                messaggioAssistenza = appoperc + "\n" + appogen;
            }
            String appo2 = "";
            if (!(dich.trim().equals("") || 1080 <= coderrInt && coderrInt <= 1084)) {
                appo2 = appo2 + "Valore dichiarato: " + Util.formStr(16, dich, 'L');
            }
            messaggioAssistenza = messaggioAssistenza + "\n" + appo2;
            appo2 = "";
            if (!(calc.trim().equals("") || 1080 <= coderrInt && coderrInt <= 1084)) {
                appo2 = !calc2.trim().equals("") ? appo2 + "Valore corretto compreso tra " + calc + " e " + calc2 + "\n" : appo2 + "Valore corretto  : " + Util.formStr(16, calc, 'L') + "\n";
            }
            messaggioAssistenza = messaggioAssistenza + "\n" + appo2;
        } else {
            messaggioAssistenza = "La procedura ha incontrato un codice errore non previsto!";
        }
        return Util.accapo(40, messaggioAssistenza);
    }

    public String decodificaDiagnostico() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, IOException {
        String appogen = "";
        StringBuffer recBuffer = new StringBuffer();
        String coderr = this.rigaString.substring(19, 23);
        int coderrInt = Util.valoreInt(coderr);
        int varComb = 0;
        String descErr = this.getDescrizione(coderr);
        String campo = this.rigaString.substring(23, 39);
        String quadro = campo.substring(0, 2);
        String rig = campo.substring(2, 5);
        String col = campo.substring(5, 8);
        String mod = campo.substring(8, campo.length()).trim();
        String dich = this.rigaString.substring(39, 55);
        if (coderrInt != 1094) {
            dich = dich.trim();
        }
        String calc = this.rigaString.substring(55, 71).trim();
        String calc2 = this.rigaString.substring(71, 84).trim();
        String CFperc = this.rigaString.substring(84, 100).trim();
        if (quadro.equals("KQ")) {
            quadro = "IQ";
            campo = quadro + campo.substring(2, campo.length());
        }
        if (dich.length() >= 2 && dich.substring(0, 2).equals("KQ")) {
            dich = "IQ" + dich.substring(2, dich.length());
        }
        if (calc.length() >= 2 && calc.substring(0, 2).equals("KQ")) {
            calc = "IQ" + calc.substring(2, calc.length());
        }
        if (quadro.equals("YY")) {
            String[] messaggi = this.decodificaSettore();
            for (int k = 0; k < messaggi.length; ++k) {
                this.writeRecLine(messaggi[k], recBuffer);
            }
        } else {
            if (BaseTelem.currentSystem == 1) {
                String stringaAsterischi = this.impostaAsterischi();
                this.writeRecLine(stringaAsterischi, recBuffer);
            }
            if (descErr != null && !descErr.equals("")) {
                String appo1;
                if (quadro.equals("  ")) {
                    this.writeRecLine(descErr, recBuffer);
                } else if (quadro.equals("MM")) {
                    appo1 = mod;
                    this.writeRecLine(descErr + appo1, recBuffer);
                } else if (quadro.equals("XX")) {
                    boolean recPosizionale;
                    String tipoRec = campo.substring(2, 3);
                    if (tipoRec.equals("X") || tipoRec.equals("Y")) {
                        tipoRec = "B";
                    }
                    boolean bl = recPosizionale = tipoRec.equals("A") || tipoRec.equals("B") || tipoRec.equals("Z") || tipoRec.equals("C");
                    if (tipoRec.equals("A") || tipoRec.equals("Z") || tipoRec.equals("C")) {
                        this.writeRecLine("Record tipo " + tipoRec + (tipoRec.equals("C") && this.modello.startsWith("FOR") && mod.length() > 0 ? " - progressivo " + Integer.parseInt(mod) : "") + (recPosizionale ? ":" : " (parte posizionale):"), recBuffer);
                    }
                    if (tipoRec.equals("B")) {
                        this.writeRecLine("Dati del Frontespizio" + (tipoRec.equals("C") && this.modello.startsWith("FOR") && mod.length() > 0 ? " - progressivo " + Integer.parseInt(mod) : "") + (recPosizionale ? ":" : " (parte posizionale):"), recBuffer);
                    }
                    String descCampo = campo.substring(2, 5).trim().length() == 3 ? this.getDescrizione(campo.substring(2, 5).trim()) + " - " : "";
                    this.writeRecLine(descCampo + this.getDescrizione(coderr), recBuffer);
                }
                if (!(quadro.equals("  ") || quadro.equals("XX") || quadro.equals("MM"))) {
                    String calc3;
                    String appomod = "";
                    String appoperc = "";
                    if (!CFperc.equals("") && !CFperc.equals("0")) {
                        appoperc = " - Codice fiscale " + (this.modello.substring(0, 3).equals("INP") ? "iscritto " : "percipiente: ") + CFperc;
                    }
                    appo1 = "Q" + quadro;
                    if (!mod.equals("")) {
                        appomod = "  Modulo " + Integer.parseInt(mod);
                    }
                    String dich3 = dich.length() > 8 ? dich.substring(0, 8) : dich;
                    String string = calc3 = calc.length() > 8 ? calc.substring(0, 8) : calc;
                    if (1080 <= coderrInt && coderrInt <= 1084) {
                        appogen = "Campo " + dich3 + " " + descErr + " campo " + calc3;
                    } else {
                        if (this.getDescrizione(quadro + rig + col) != null && this.getDescrizione(quadro + rig + col).trim().length() != 0) {
                            varComb = 8;
                        } else if (this.modello.substring(0, 3).equals("INP") && this.getDescrizione(quadro + "XXX" + col) != null && this.getDescrizione(quadro + "XXX" + col).trim().length() != 0) {
                            varComb = 8;
                        } else {
                            if (!rig.equals("   ")) {
                                ++varComb;
                            }
                            if (!col.equals("   ")) {
                                varComb += 2;
                            }
                            if (!mod.equals("")) {
                                varComb += 4;
                            }
                        }
                        switch (varComb) {
                            case 0: {
                                appogen = descErr;
                                break;
                            }
                            case 1: {
                                appogen = "Rigo " + rig + " - " + descErr;
                                break;
                            }
                            case 3: {
                                appogen = "Rigo " + rig + " Colonna " + col + " - " + descErr;
                                break;
                            }
                            case 4: {
                                appogen = descErr;
                                break;
                            }
                            case 5: {
                                appogen = "Rigo " + rig + " - " + descErr;
                                break;
                            }
                            case 7: {
                                appogen = "Codice " + quadro + " " + rig + " " + col + "  - " + descErr;
                                break;
                            }
                            case 8: {
                                if (this.modello.substring(0, 3).equals("INP") && !quadro.equals("D0")) {
                                    appogen = BaseTelem.getInstance().getDescrizione(quadro + "XXX" + col) + " (Rigo " + rig + ")  - " + descErr;
                                    break;
                                }
                                appogen = BaseTelem.getInstance().getDescrizione(quadro + rig + col) + "  - " + descErr;
                                break;
                            }
                            default: {
                                appo1 = "";
                                dich = "";
                                calc = "";
                                this.writeRecLine("\n", recBuffer);
                                this.writeRecLine("La procedura ha incontrato un codice campo non previsto!", recBuffer);
                                this.writeRecLine(" Codice campo: " + campo, recBuffer);
                            }
                        }
                    }
                    if (this.modello.substring(0, 3).equals("730") && quadro.equals("FM")) {
                        this.writeRecLine("Tipo Record M", recBuffer);
                    } else {
                        this.writeRecLine(this.getDescrizione(appo1) + appomod + appoperc, recBuffer);
                    }
                    this.writeRecLine(appogen, recBuffer);
                }
                String appo2 = "";
                if (!(dich.trim().equals("") && coderrInt != 1094 || 1080 <= coderrInt && coderrInt <= 1084)) {
                    appo2 = " Valore dichiarato: " + Util.formStr(16, dich, 'L');
                }
                this.writeRecLine(appo2, recBuffer);
                appo2 = "";
                if (!(calc.trim().equals("") || 1080 <= coderrInt && coderrInt <= 1084)) {
                    appo2 = !calc2.trim().equals("") ? " Valore corretto compreso tra " + calc + " e " + calc2 + "\n" : " Valore corretto  : " + Util.formStr(16, calc, 'L') + "\n";
                }
                this.writeRecLine(appo2, recBuffer);
            } else {
                this.writeRecLine("\n\n", recBuffer);
                this.writeRecLine("La procedura ha incontrato un codice errore non previsto!", recBuffer);
                this.writeRecLine(" Codice errore: " + coderr, recBuffer);
            }
        }
        return recBuffer.toString();
    }

    private String[] decodificaSettore() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        boolean isControllo = BaseTelem.currentSystem == 1;
        Class<?> gestoreErrore = Class.forName("finanze.IDTE.studi2015.decod.GestoreMessaggioErrore");
        Method met = gestoreErrore.getMethod("interpretaRecordsDGN", String.class, Boolean.TYPE);
        String[] messaggio = (String[])met.invoke(gestoreErrore, this.rigaString, new Boolean(isControllo));
        return messaggio;
    }

    protected void elaboraFile(String[] args) throws MainException {
        FileInputStream fileInput = null;
        try {
            String CFmem;
            String CF2;
            int i = 0;
            int fl_CF = 1;
            boolean fl_0 = true;
            String CFbianco = "";
            Vector<String> dich = new Vector<String>();
            String campoUtente = new String();
            File input = new File(args[0]);
            if (input.length() % 106L != 0L) {
                throw new RuntimeException("Errore nella struttura del file diagnostico");
            }
            String dataS = Util.mills2Date(input.lastModified());
            String titoloElenco = "Elenco completo dei diagnostici relativi alla procedura di controllo dell'archivio";
            int errore = 0;
            if (args.length == 2) {
                errore = Integer.parseInt(args[1]);
                if (errore == 2) {
                    titoloElenco = "Elenco dei diagnostici relativi alle dichiarazioni escluse dall'assistenza fiscale contenute nell'archivio";
                } else if (errore == 3) {
                    titoloElenco = "Elenco dei diagnostici relativi alle sole dichiarazioni scartate contenute nell'archivio";
                }
                errore = this.impostaTipoErrore(errore);
            }
            fileInput = new FileInputStream(input);
            FileOutputStream tempOutput = new FileOutputStream("temp.dgn");
            byte[] rigaByteIn = new byte[106];
            i = fileInput.read(rigaByteIn);
            this.rigaString = new String(rigaByteIn);
            this.modello = this.rigaString.substring(2, 7);
            System.out.print("Esecuzione ");
            while (i == 106) {
                switch (this.rigaString.charAt(0)) {
                    case '0': 
                    case '9': {
                        tempOutput.write(rigaByteIn);
                        i = fileInput.read(rigaByteIn);
                        this.rigaString = new String(rigaByteIn);
                        break;
                    }
                    case '1': {
                        CFmem = CF2 = this.rigaString.substring(1, 17);
                        int tipoErrore = 0;
                        while (CF2.equals(CFmem) && i != -1) {
                            String campo = this.rigaString.substring(23, 26);
                            if (campo.equals("XXA") || campo.equals("XXZ")) {
                                if ("730".equals(this.modello.substring(0, 3)) && errore == 12 || errore == 16) {
                                    tipoErrore = -1;
                                }
                            } else {
                                tipoErrore = Integer.parseInt(this.rigaString.substring(17, 19));
                            }
                            if (errore <= tipoErrore) {
                                dich.addElement(this.rigaString);
                            }
                            i = fileInput.read(rigaByteIn);
                            this.rigaString = new String(rigaByteIn);
                            CF2 = this.rigaString.substring(1, 17);
                        }
                        if (dich.size() < 1000) {
                            dich = this.sort(dich);
                        }
                        for (int j = 0; j < dich.size(); ++j) {
                            tempOutput.write(((String)dich.elementAt(j)).getBytes());
                        }
                        dich = new Vector<String>();
                    }
                }
            }
            fileInput.close();
            tempOutput.close();
            this.bufferedOutput = new BufferedWriter(new FileWriter(Util.cambiaEstensione(args[0], "wri")));
            File tempFile = new File("temp.dgn");
            fileInput = new FileInputStream(tempFile);
            CFmem = Util.formStr(16, "", 'L');
            if (tempFile.length() % 106L == 0L) {
                String descrSettore;
                i = fileInput.read(rigaByteIn);
                this.rigaString = new String(rigaByteIn);
                this.writeRecLine(Util.formStr(80, "Data: " + dataS, 'L'));
                this.writeRecLine(this.trovaModello());
                this.writeRecLine("Versione " + this.rigaString.substring(59, 67).trim() + " del " + this.rigaString.substring(67, 77));
                if ((this.modello.startsWith("UNI") || this.modello.startsWith("U50") || this.modello.startsWith("U60") || this.modello.startsWith("U61")) && (descrSettore = MainUnico.descrizioneSettore()).length() > 1) {
                    this.writeRecLine("Modulo controllo" + descrSettore.substring(1));
                }
                this.writeRecLine("\n");
                while (i == 106) {
                    if (this.rigaString.charAt(0) == '1') {
                        if (fl_0) {
                            this.addLegendaErrori();
                        }
                        fl_0 = false;
                        CF2 = this.rigaString.substring(1, 17);
                        fl_CF = this.addTitolo(CFmem, CFbianco);
                        CFbianco = "";
                        if (fl_CF == 2) {
                            CFbianco = this.rigaString.substring(55, 71);
                        }
                        CFmem = CF2;
                        int maxErr = 0;
                        System.out.print(".");
                        while (CF2.equals(CFmem) && i != -1) {
                            int err;
                            if (fl_CF != 2) {
                                this.decodificaDiagnostico();
                            }
                            if ((err = Integer.parseInt(this.rigaString.substring(17, 19))) > maxErr) {
                                maxErr = err;
                            }
                            i = fileInput.read(rigaByteIn);
                            this.rigaString = new String(rigaByteIn);
                            CF2 = this.rigaString.substring(1, 17);
                        }
                        if (fl_CF != 1) continue;
                        this.scriviTipoErrore(maxErr);
                        continue;
                    }
                    if (this.rigaString.charAt(0) == '9') {
                        this.coda();
                    }
                    if (this.rigaString.charAt(0) == '0') {
                        switch (this.rigaString.charAt(1)) {
                            case '*': {
                                this.writeRecLine("\n" + titoloElenco + ": \n<<" + this.rigaString.substring(17, this.rigaString.length() - 1).trim() + ">>");
                                break;
                            }
                            case 'N': {
                                campoUtente = campoUtente + this.rigaString.substring(9, 59);
                                break;
                            }
                            case 'U': {
                                this.writeRecLine(campoUtente + this.rigaString.substring(9, 59).trim());
                            }
                        }
                    }
                    i = fileInput.read(rigaByteIn);
                    this.rigaString = new String(rigaByteIn);
                }
            } else {
                this.writeRecLine("L'archivio del quale e' stata richiesta la visualizzazione non e' un archivio dei diagnostici");
            }
            fileInput.close();
            this.bufferedOutput.close();
            tempFile.delete();
            System.out.println("Fine");
        }
        catch (Throwable t) {
            try {
                if (fileInput != null) {
                    fileInput.close();
                    fileInput = null;
                }
                if (this.bufferedOutput != null) {
                    this.bufferedOutput.close();
                    this.bufferedOutput = null;
                }
            }
            catch (IOException fl_CF) {
                // empty catch block
            }
            CharArrayWriter os = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(os);
            t.printStackTrace(pw);
            MainException me = new MainException(os.toString());
            System.out.println(me.toString());
            throw me;
        }
    }

    public BufferedWriter getBufferedOutput() {
        return this.bufferedOutput;
    }

    public String getCodiceCampo() {
        return this.rigaString.substring(23, 39);
    }

    public String getDescrizione(String codice) {
        return BaseTelem.getInstance().getDescrizione(codice);
    }

    private String impostaAsterischi() {
        String rigaAst = "";
        int coderr = Integer.parseInt(this.rigaString.substring(17, 19));
        if (coderr == 4) {
            rigaAst = "(*)";
        } else if (coderr == 8) {
            rigaAst = "(**)";
        } else if (coderr == 12) {
            if (this.modello.substring(0, 3).equals("730") && !this.rigaString.substring(1, 17).equals("AAAAAAAAAAAAAAAA") && !this.rigaString.substring(1, 17).equals("ZZZZZZZZZZZZZZZZ")) {
                rigaAst = "(**E)";
            }
        } else if (coderr == 14) {
            rigaAst = "(***C)";
        } else if (coderr > 14 && coderr < 24) {
            rigaAst = "(***)";
        } else if (coderr >= 24) {
            rigaAst = "(****)";
        }
        return rigaAst;
    }

    private int impostaTipoErrore(int err) {
        int retErr = 0;
        if (err == 2) {
            retErr = 12;
        } else if (err == 3) {
            retErr = 14;
        }
        return retErr;
    }

    public static void main(String[] args) throws MainException {
        new Visual().elaboraFile(args);
    }

    public void riempiDescrizioni(boolean isModUnico) throws FileNotFoundException, IOException {
        BaseTelem.getInstance().riempiDescrizioni(this.modello, isModUnico);
    }

    protected void scriviTipoErrore(int maxErr) throws IOException {
        this.writeRecLine("\n");
        if (maxErr <= 11) {
            this.writeRecLine("La dichiarazione pu\u00f2 essere trasmessa.");
            if (this.modello.substring(0, 3).equals("730")) {
                this.writeRecLine("Presenza di errori che NON comportano l'esclusione dall'assistenza fiscale.");
            }
        } else if (maxErr == 12) {
            this.writeRecLine("La dichiarazione pu\u00f2 essere trasmessa.");
            if (this.modello.substring(0, 3).equals("730")) {
                this.writeRecLine("Presenza di errori che comportano l'esclusione dall'assistenza fiscale.");
            }
        } else if (maxErr == 14) {
            this.writeRecLine("La dichiarazione \u00e8 scartata per non rispondenza.");
        } else if (maxErr >= 16) {
            this.writeRecLine("La dichiarazione \u00e8 scartata per presenza di errori bloccanti.");
        }
    }

    public void setBufferedOutput(BufferedWriter bufferedOutput) {
        this.bufferedOutput = bufferedOutput;
    }

    public void setModello(String modello) {
        this.modello = modello;
    }

    public void setRigastring(String newRigaString) {
        this.rigaString = newRigaString;
    }

    public void setWeb(boolean flag) {
        this.isWeb = flag;
    }

    private Vector sort(Vector dich) throws Exception {
        String[] keys = new String[dich.size()];
        for (int i = 0; i < dich.size(); ++i) {
            String prec = (String)dich.elementAt(i);
            prec = prec.substring(23, 25).equals("XX") ? "00" + prec.substring(31, 39) + prec.substring(25, 31) : prec.substring(23, 25) + prec.substring(31, 39) + prec.substring(25, 31);
            keys[i] = prec;
        }
        QSortAlgorithm2 q = new QSortAlgorithm2();
        dich = q.sort(keys, dich);
        return dich;
    }

    protected String trovaModello() throws FileNotFoundException, IOException {
        String descrizione = this.modello.substring(0, 3);
        boolean isModUnico = true;
        String descrizione2 = " - Procedura di Controllo delle Dichiarazioni";
        if (this.modello.startsWith("UNI")) {
            descrizione = "Unico Persone Fisiche";
        } else if (this.modello.startsWith("U50")) {
            descrizione = "Unico Societ\u00e0 di Persone";
        } else if (this.modello.startsWith("U60")) {
            descrizione = "Unico Societ\u00e0 di Capitali";
        } else if (this.modello.startsWith("U61")) {
            descrizione = "Unico Enti non Commerciali";
        } else {
            isModUnico = false;
            if (this.modello.startsWith("UNR")) {
                descrizione = "Unico non Residenti";
            } else if (this.modello.startsWith("ELI")) {
                descrizione = "Dichiarazione di Emersione";
            } else if (this.modello.startsWith("ELP")) {
                descrizione = "Dichiarazione di Emersione Progressiva";
            } else if (this.modello.startsWith("FOR")) {
                descrizione = "Forniture di Documenti Fiscali";
            } else if (this.modello.startsWith("IVD")) {
                descrizione = "Dichiarazione Modello IVD";
            } else if (this.modello.startsWith("INP")) {
                descrizione = "Denunce Mensili Analitiche";
                descrizione2 = " - Procedura di Controllo delle DMA";
            } else if (this.modello.startsWith("IVT")) {
                descrizione = "IVA TR";
            }
        }
        this.riempiDescrizioni(isModUnico);
        return "Mod. " + descrizione + (this.modello.startsWith("ELI") || this.modello.startsWith("ELP") || this.modello.startsWith("FOR") || this.modello.startsWith("IVT") ? "" : " 20" + this.modello.substring(3)) + descrizione2;
    }

    protected void writeRecLine(String line) throws IOException {
        this.writeRecLine(line, true);
    }

    protected void writeRecLine(String line, StringBuffer recBuffer) throws IOException {
        if (this.bufferedOutput != null) {
            this.writeRecLine(line);
        } else {
            line = Util.accapo(80, line);
        }
        recBuffer.append(line).append('\n');
    }

    protected void writeRecLine(String line, boolean formatLine) throws IOException {
        if (formatLine) {
            line = Util.accapo(80, line);
        }
        this.bufferedOutput.write(line + '\n');
    }
}

