/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EnvelopedData;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.PasswordRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class CMSPasswordRecipientInfo {
    SecureRandom random;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        char[] cArray = "topSecret".toCharArray();
        try {
            byte[] byArray2 = null;
            int n = 24;
            int n2 = 1;
            byte[] byArray3 = new byte[16];
            this.random.nextBytes(byArray3);
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(UTF8String.getUTF8EncodingFromCharArray((char[])cArray), byArray3, n2, n);
            System.out.println("Stream implementation demo");
            System.out.println("===========================");
            System.out.println("\nEnvelopedDataStream demo [create]:\n");
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.pbkdf2.clone();
            AlgorithmID algorithmID2 = (AlgorithmID)CMSAlgorithmID.pwri_kek.clone();
            AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone();
            algorithmID2.setParameter(algorithmID3.toASN1Object());
            String string2 = "3DES";
            byte[] byArray4 = this.createEnvelopedDataStream(byArray, null, (AlgorithmID)algorithmID.clone(), (AlgorithmParameterSpec)pBEKeyAndParameterSpec, algorithmID2, null);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray4, cArray, string2);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demo");
            System.out.println("===============================");
            System.out.println("\nEnvelopedData demo [create]:\n");
            algorithmID = (AlgorithmID)AlgorithmID.pbkdf2.clone();
            algorithmID2 = (AlgorithmID)CMSAlgorithmID.pwri_kek.clone();
            algorithmID3 = (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone();
            algorithmID2.setParameter(algorithmID3.toASN1Object());
            string2 = "3DES";
            byArray4 = this.createEnvelopedData(byArray, null, algorithmID, (AlgorithmParameterSpec)pBEKeyAndParameterSpec, algorithmID2, null);
            System.out.println("\nEnvelopedData demo [parse]:\n");
            byArray2 = this.getEnvelopedData(byArray4, cArray, string2);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("Ready!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSPasswordRecipientInfo().start();
        System.in.read();
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, char[] cArray, String string) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfoStream contentInfoStream = new ContentInfoStream((InputStream)byteArrayInputStream);
        EnvelopedDataStream envelopedDataStream = (EnvelopedDataStream)contentInfoStream.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nInformation about the RecipientInfo :");
        PasswordRecipientInfo passwordRecipientInfo = (PasswordRecipientInfo)envelopedDataStream.getRecipientInfos()[0];
        System.out.println(passwordRecipientInfo);
        try {
            SecretKey secretKey = passwordRecipientInfo.decryptKey(cArray, string);
            envelopedDataStream.setupCipher((Key)secretKey);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new CMSException("Cannot decrypt message. " + exception.toString());
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, char[] cArray, String string) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ContentInfo contentInfo = new ContentInfo((InputStream)byteArrayInputStream);
        EnvelopedData envelopedData = (EnvelopedData)contentInfo.getContent();
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nInformation about the RecipientInfo :");
        PasswordRecipientInfo passwordRecipientInfo = (PasswordRecipientInfo)envelopedData.getRecipientInfos()[0];
        System.out.println(passwordRecipientInfo);
        try {
            SecretKey secretKey = passwordRecipientInfo.decryptKey(cArray, string);
            envelopedData.setupCipher((Key)secretKey);
            return envelopedData.getContent();
        }
        catch (Exception exception) {
            throw new CMSException("Cannot decrypt message: " + exception.toString());
        }
    }

    public byte[] createEnvelopedDataStream(byte[] byArray, char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, AlgorithmParameters algorithmParameters) throws IOException, CMSException {
        PasswordRecipientInfo passwordRecipientInfo;
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        try {
            passwordRecipientInfo = new PasswordRecipientInfo(cArray, algorithmID, algorithmParameterSpec, algorithmID2, algorithmParameters);
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create PasswordRecipientInfo: " + exception.toString());
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{passwordRecipientInfo};
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.setBlockSize(2048);
        ContentInfoStream contentInfoStream = new ContentInfoStream((ContentStream)envelopedDataStream);
        contentInfoStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEnvelopedData(byte[] byArray, char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmID algorithmID2, AlgorithmParameters algorithmParameters) throws CMSException {
        PasswordRecipientInfo passwordRecipientInfo;
        EnvelopedData envelopedData;
        try {
            envelopedData = new EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        try {
            passwordRecipientInfo = new PasswordRecipientInfo(cArray, algorithmID, algorithmParameterSpec, algorithmID2, algorithmParameters);
        }
        catch (Exception exception) {
            throw new CMSException("Cannot create PasswordRecipientInfo: " + exception.toString());
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[]{passwordRecipientInfo};
        envelopedData.setRecipientInfos(recipientInfoArray);
        ContentInfo contentInfo = new ContentInfo((Content)envelopedData);
        return contentInfo.toByteArray();
    }

    public CMSPasswordRecipientInfo() {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                   CMSPasswordRecipientInfo demo                                *");
        System.out.println("*    (shows the usage of the CMS PasswordRecipientInfo type implementation)      *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.random = SecRandom.getDefault();
    }
}

