/*
 * Decompiled with CFR 0.152.
 */
package demo.keystore;

import demo.DemoUtil;
import demo.keystore.CMSKeyStoreConstants;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.cms.Utils;
import iaik.x509.SimpleChainVerifier;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.GregorianCalendar;
import java.util.Random;

public class SetupCMSKeyStore
implements CMSKeyStoreConstants {
    boolean create_ssdh;
    boolean create_esdh = this.create_ssdh = Utils.isClassAvailable((String)"iaik.security.dh.ESDHPublicKey");
    boolean create_dsa = true;
    boolean create_rsa = true;
    KeyPair ssdh1024_;
    KeyPair ssdh1024;
    KeyPair esdh2048;
    KeyPair esdh1024_;
    KeyPair esdh1024;
    KeyPair esdh512;
    KeyPair dsa1024;
    KeyPair dsa512;
    KeyPair ca_dsa;
    KeyPair rsa2048_crypt;
    KeyPair rsa1024_crypt_;
    KeyPair rsa1024_crypt;
    KeyPair rsa512_crypt;
    KeyPair rsa2048_sign;
    KeyPair rsa1024_sign;
    KeyPair rsa512_sign;
    KeyPair ca_rsa;
    boolean create_only_certificates = true;
    String keystore_file;
    KeyStore key_store;
    private static final int a = 1024;

    public static void start() {
        SetupCMSKeyStore setupCMSKeyStore = new SetupCMSKeyStore();
        setupCMSKeyStore.c();
        if (setupCMSKeyStore.create_only_certificates) {
            setupCMSKeyStore.b();
        } else {
            setupCMSKeyStore.a();
        }
        setupCMSKeyStore.generateCertificates();
        setupCMSKeyStore.d();
    }

    private void d() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.keystore_file);
            this.key_store.store(fileOutputStream, CMSKeyStoreConstants.KS_PASSWORD);
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            System.out.println("Error saving KeyStore!");
            exception.printStackTrace();
            return;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initDemos();
        SetupCMSKeyStore.start();
        System.in.read();
    }

    private void c() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = System.getProperty("user.dir");
            File file = new File(string, "cms.keystore");
            if (file.exists()) {
                this.keystore_file = file.getAbsolutePath();
                if (this.create_only_certificates) {
                    System.out.println("Create only new certificates from already existing keys!");
                } else {
                    System.out.println("Existing KeyStore will be deleted!");
                }
                System.out.println("KeyStore: " + this.keystore_file);
            } else {
                this.create_only_certificates = false;
                while (true) {
                    System.out.print("Create new KeyStore in directory: " + string + " [y]");
                    String string2 = bufferedReader.readLine();
                    if (string2.length() == 0 || string2.equals("y")) {
                        file = new File(string, "cms.keystore");
                        this.keystore_file = file.getAbsolutePath();
                        System.out.println("KeyStore will be saved to: " + this.keystore_file);
                        break;
                    }
                    System.out.print("Enter directory: ");
                    string = bufferedReader.readLine();
                }
            }
            this.key_store = KeyStore.getInstance("IAIKKeyStore");
            if (this.create_only_certificates) {
                this.key_store.load(new FileInputStream(file), CMSKeyStoreConstants.KS_PASSWORD);
                return;
            }
            this.key_store.load(null, null);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error creating new IAIK KeyStore!");
            throw new RuntimeException("Error creating new KeyStore: " + exception.getMessage());
        }
    }

    private void b() {
        try {
            this.ca_rsa = this.a("CA.RSA");
            this.rsa512_sign = this.a("RSA_SIGN.512");
            this.rsa1024_sign = this.a("RSA_SIGN.1024");
            this.rsa2048_sign = this.a("RSA_SIGN.2048");
            this.rsa512_crypt = this.a("RSA_CRYPT.512");
            this.rsa1024_crypt = this.a("RSA_CRYPT.1024");
            this.rsa1024_crypt_ = this.a("RSA_CRYPT_.1024");
            this.rsa2048_crypt = this.a("RSA_CRYPT.2048");
        }
        catch (Exception exception) {
            System.out.println("Unable to get RSA keys from KeyStore.");
            exception.printStackTrace();
            this.create_rsa = false;
        }
        try {
            this.ca_dsa = this.a("CA.DSA");
            this.dsa512 = this.a("DSA.512");
            this.dsa1024 = this.a("DSA.1024");
        }
        catch (Exception exception) {
            System.out.println("Unable to get DSA keys from KeyStore.");
            exception.printStackTrace();
            this.create_dsa = false;
        }
        try {
            this.esdh512 = this.a("ESDH.512");
            this.esdh1024 = this.a("ESDH.1024");
            this.esdh1024_ = this.a("ESDH_.1024");
            this.esdh2048 = this.a("ESDH.2048");
        }
        catch (Exception exception) {
            System.out.println("Unable to get ESDH keys from KeyStore.");
            exception.printStackTrace();
            this.create_esdh = false;
        }
        try {
            this.ssdh1024 = this.a("SSDH.1024");
            this.ssdh1024_ = this.a("SSDH_.1024");
            return;
        }
        catch (Exception exception) {
            System.out.println("Unable to get SSDH keys from KeyStore.");
            exception.printStackTrace();
            this.create_ssdh = false;
            return;
        }
    }

    private KeyPair a(String string) throws Exception {
        PrivateKey privateKey = (PrivateKey)this.key_store.getKey(string, CMSKeyStoreConstants.KS_PASSWORD);
        PublicKey publicKey = this.key_store.getCertificateChain(string)[0].getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    private void a() {
        try {
            if (this.create_rsa) {
                try {
                    System.out.println("generate RSA KeyPair for CA certificate [" + 1024 + " bits]...");
                    this.ca_rsa = SetupCMSKeyStore.generateKeyPair("RSA", 1024);
                    System.out.println("Generate RSA signing keys...");
                    System.out.println("generate RSA KeyPair for a test certificate [512 bits]...");
                    this.rsa512_sign = SetupCMSKeyStore.generateKeyPair("RSA", 512);
                    System.out.println("generate RSA KeyPair for a test certificate [1024 bits]...");
                    this.rsa1024_sign = SetupCMSKeyStore.generateKeyPair("RSA", 1024);
                    System.out.println("generate RSA KeyPair for a test certificate [2048 bits]...");
                    this.rsa2048_sign = SetupCMSKeyStore.generateKeyPair("RSA", 2048);
                    System.out.println("Generate RSA encryption keys...");
                    System.out.println("generate RSA KeyPair for a test certificate [512 bits]...");
                    this.rsa512_crypt = SetupCMSKeyStore.generateKeyPair("RSA", 512);
                    System.out.println("generate RSA KeyPair for a test certificate [1024 bits]...");
                    this.rsa1024_crypt = SetupCMSKeyStore.generateKeyPair("RSA", 1024);
                    System.out.println("generate second RSA KeyPair for a test certificate [1024 bits]...");
                    this.rsa1024_crypt_ = SetupCMSKeyStore.generateKeyPair("RSA", 1024);
                    System.out.println("generate RSA KeyPair for a test certificate [2048 bits]...");
                    this.rsa2048_crypt = SetupCMSKeyStore.generateKeyPair("RSA", 2048);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.create_rsa = false;
                    System.out.println("No implementation for RSA! RSA certificates are not created!\n");
                }
            }
            if (this.create_dsa) {
                try {
                    System.out.println("generate DSA KeyPair for CA certificate [" + 1024 + " bits]...");
                    this.ca_dsa = SetupCMSKeyStore.generateKeyPair("DSA", 1024);
                    System.out.println("generate DSA KeyPair for a test certificate [512 bits]...");
                    this.dsa512 = SetupCMSKeyStore.generateKeyPair("DSA", 512);
                    System.out.println("generate DSA KeyPair for a test certificate [1024 bits]...");
                    this.dsa1024 = SetupCMSKeyStore.generateKeyPair("DSA", 1024);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.create_dsa = false;
                    System.out.println("No implementation for DSA! DSA certificates are not created!\n");
                }
            }
            if (this.create_esdh) {
                try {
                    System.out.println("generate ESDH KeyPair for a test certificate [512 bits]...");
                    this.esdh512 = SetupCMSKeyStore.generateKeyPair("ESDH", 512);
                    System.out.println("generate ESDH KeyPair for a test certificate [1024 bits]...");
                    this.esdh1024 = SetupCMSKeyStore.generateKeyPair("ESDH", 1024);
                    System.out.println("generate ESDH KeyPair for a test certificate [1024 bits]...");
                    this.esdh1024_ = SetupCMSKeyStore.generateKeyPair("ESDH", 1024);
                    System.out.println("generate ESDH KeyPair for a test certificate [2048 bits]...");
                    this.esdh2048 = SetupCMSKeyStore.generateKeyPair("ESDH", 2048);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.create_esdh = false;
                    System.out.println("No implementation for ESDH! ESDH certificates are not created!\n");
                }
            }
            if (this.create_ssdh) {
                try {
                    System.out.println("generate SSDH KeyPair for a test certificate [1024 bits]...");
                    this.ssdh1024 = SetupCMSKeyStore.generateKeyPair("ESDH", 1024);
                    System.out.println("generate SSDH KeyPair for a test certificate [1024 bits]...");
                    this.ssdh1024_ = SetupCMSKeyStore.generateKeyPair("ESDH", 1024);
                    return;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.create_ssdh = false;
                    System.out.println("No implementation for SSDH! SSDH certificates are not created!\n");
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
        }
    }

    public static KeyPair generateKeyPair(String string, int n) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string, "IAIK");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("Provider IAIK not found!");
        }
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public void generateCertificates() {
        try {
            SubjectKeyIdentifier subjectKeyIdentifier;
            Name name = new Name();
            name.addRDN(ObjectID.country, (Object)"AT");
            name.addRDN(ObjectID.organization, (Object)"IAIK");
            name.addRDN(ObjectID.organizationalUnit, (Object)"JavaSecurity");
            Name name2 = new Name();
            name2.addRDN(ObjectID.country, (Object)"AT");
            name2.addRDN(ObjectID.organization, (Object)"IAIK");
            name2.addRDN(ObjectID.organizationalUnit, (Object)"JavaSecurity");
            X509Certificate x509Certificate = null;
            X509Certificate x509Certificate2 = null;
            X509Certificate[] x509CertificateArray = new X509Certificate[1];
            SimpleChainVerifier simpleChainVerifier = new SimpleChainVerifier();
            if (this.create_rsa) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK RSA Test CA");
                System.out.println("create self signed RSA CA certificate...");
                x509Certificate = SetupCMSKeyStore.createCertificate(name, this.ca_rsa.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, null, true);
                x509Certificate.verify();
                simpleChainVerifier.addTrustedCertificate((java.security.cert.X509Certificate)x509Certificate);
                x509CertificateArray[0] = x509Certificate;
                this.addToKeyStore(this.ca_rsa, x509CertificateArray, "CA.RSA");
                name.removeRDN(ObjectID.commonName);
            }
            if (this.create_dsa) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK DSA Test CA");
                System.out.println("create self signed DSA CA certificate...");
                x509Certificate2 = SetupCMSKeyStore.createCertificate(name, this.ca_dsa.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, null, true);
                x509Certificate2.verify();
                simpleChainVerifier.addTrustedCertificate((java.security.cert.X509Certificate)x509Certificate2);
                x509CertificateArray[0] = x509Certificate2;
                this.addToKeyStore(this.ca_dsa, x509CertificateArray, "CA.DSA");
                name.removeRDN(ObjectID.commonName);
            }
            x509CertificateArray = new X509Certificate[2];
            if (this.create_rsa) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK RSA Test CA");
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
                System.out.println("Create RSA demo certificates to be used for signing...");
                name2.addRDN(ObjectID.commonName, (Object)"RSA 512 bit Demo Signing Certificate");
                System.out.println("create 512 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa512_sign.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), true);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa512_sign, x509CertificateArray, "RSA_SIGN.512");
                name2.removeRDN(ObjectID.commonName);
                name2.addRDN(ObjectID.commonName, (Object)"RSA 1024 bit Demo Signing Certificate");
                System.out.println("create 1024 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa1024_sign.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), true);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa1024_sign, x509CertificateArray, "RSA_SIGN.1024");
                name2.removeRDN(ObjectID.commonName);
                name2.addRDN(ObjectID.commonName, (Object)"RSA 2048 bit Demo Signing Certificate");
                System.out.println("create 2048 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa2048_sign.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), true);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa2048_sign, x509CertificateArray, "RSA_SIGN.2048");
                name2.removeRDN(ObjectID.commonName);
                System.out.println("Create RSA demo certificates to be used for encryption...");
                name2.addRDN(ObjectID.commonName, (Object)"RSA 512 bit Demo Encryption Certificate");
                System.out.println("create 512 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa512_crypt.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), false);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa512_crypt, x509CertificateArray, "RSA_CRYPT.512");
                name2.removeRDN(ObjectID.commonName);
                name2.addRDN(ObjectID.commonName, (Object)"RSA 1024 bit Demo Encryption Certificate");
                System.out.println("create 1024 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa1024_crypt.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), false);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa1024_crypt, x509CertificateArray, "RSA_CRYPT.1024");
                System.out.println("create second 1024 bit RSA demo Encryption certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa1024_crypt_.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), false);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa1024_crypt_, x509CertificateArray, "RSA_CRYPT_.1024");
                name2.removeRDN(ObjectID.commonName);
                name2.addRDN(ObjectID.commonName, (Object)"RSA 2048 bit Demo Encryption Certificate");
                System.out.println("create 2048 bit RSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.rsa2048_crypt.getPublic(), name, this.ca_rsa.getPrivate(), AlgorithmID.sha1WithRSAEncryption, subjectKeyIdentifier.get(), false);
                x509CertificateArray[1] = x509Certificate;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.rsa2048_crypt, x509CertificateArray, "RSA_CRYPT.2048");
                name2.removeRDN(ObjectID.commonName);
                name.removeRDN(ObjectID.commonName);
            }
            if (this.create_dsa) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK DSA Test CA");
                name2.addRDN(ObjectID.commonName, (Object)"DSA 512 bit Demo Certificate");
                System.out.println("create 512 bit DSA demo certificate...");
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate2.getExtension(SubjectKeyIdentifier.oid);
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.dsa512.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), true);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.dsa512, x509CertificateArray, "DSA.512");
                name2.addRDN(ObjectID.commonName, (Object)"DSA 1024 bit Demo Certificate");
                System.out.println("create 1024 bit DSA demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.dsa1024.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), true);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.dsa1024, x509CertificateArray, "DSA.1024");
                name.removeRDN(ObjectID.commonName);
            }
            if (this.create_esdh) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK DSA Test CA");
                name2.addRDN(ObjectID.commonName, (Object)"ESDH 512 bit Demo Certificate");
                System.out.println("create 512 bit ESDH demo certificate...");
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate2.getExtension(SubjectKeyIdentifier.oid);
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.esdh512.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.esdh512, x509CertificateArray, "ESDH.512");
                name2.addRDN(ObjectID.commonName, (Object)"ESDH 1024 bit Demo Certificate 1");
                System.out.println("create 1024 bit ESDH demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.esdh1024.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.esdh1024, x509CertificateArray, "ESDH.1024");
                name2.addRDN(ObjectID.commonName, (Object)"ESDH 1024 bit Demo Certificate 2");
                System.out.println("create second 1024 bit ESDH demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.esdh1024_.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.esdh1024_, x509CertificateArray, "ESDH_.1024");
                name2.addRDN(ObjectID.commonName, (Object)"ESDH 2048 bit Demo Certificate");
                System.out.println("create 2048 bit ESDH demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.esdh2048.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.esdh2048, x509CertificateArray, "ESDH.2048");
                name.removeRDN(ObjectID.commonName);
            }
            if (this.create_ssdh) {
                name.addRDN(ObjectID.commonName, (Object)"IAIK DSA Test CA");
                subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate2.getExtension(SubjectKeyIdentifier.oid);
                name2.addRDN(ObjectID.commonName, (Object)"SSDH 1024 bit Demo Certificate 1");
                System.out.println("create 1024 bit SSDH demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.ssdh1024.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.ssdh1024, x509CertificateArray, "SSDH.1024");
                name2.addRDN(ObjectID.commonName, (Object)"SSDH 1024 bit Demo Certificate 2");
                System.out.println("create second 1024 bit SSDH demo certificate...");
                x509CertificateArray[0] = SetupCMSKeyStore.createCertificate(name2, this.ssdh1024_.getPublic(), name, this.ca_dsa.getPrivate(), AlgorithmID.dsaWithSHA, subjectKeyIdentifier.get(), false);
                name2.removeRDN(ObjectID.commonName);
                x509CertificateArray[1] = x509Certificate2;
                simpleChainVerifier.verifyChain((java.security.cert.X509Certificate[])x509CertificateArray);
                this.addToKeyStore(this.ssdh1024_, x509CertificateArray, "SSDH_.1024");
                name.removeRDN(ObjectID.commonName);
            }
            System.out.println("\nCertificates created!");
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return;
        }
    }

    public static X509Certificate createCertificate(Name name, PublicKey publicKey, Name name2, PrivateKey privateKey, AlgorithmID algorithmID, byte[] byArray, boolean bl) {
        X509Certificate x509Certificate = new X509Certificate();
        try {
            SubjectAltName subjectAltName;
            PolicyInformation[] policyInformationArray;
            KeyUsage keyUsage;
            Object object;
            x509Certificate.setSerialNumber(new BigInteger(20, new Random()));
            x509Certificate.setSubjectDN((Principal)name);
            x509Certificate.setPublicKey(publicKey);
            x509Certificate.setIssuerDN((Principal)name2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.add(5, -1);
            x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
            if (name2.equals((Object)name)) {
                gregorianCalendar.add(2, 12);
                object = new BasicConstraints(true);
                x509Certificate.addExtension((V3Extension)object);
                keyUsage = new KeyUsage(96);
                x509Certificate.addExtension((V3Extension)keyUsage);
            } else {
                gregorianCalendar.add(2, 11);
                object = null;
                object = bl ? new KeyUsage(3) : (publicKey.getAlgorithm().equalsIgnoreCase("ESDH") ? new KeyUsage(28) : new KeyUsage(12));
                x509Certificate.addExtension((V3Extension)object);
                keyUsage = new AuthorityKeyIdentifier();
                keyUsage.setKeyIdentifier(byArray);
                x509Certificate.addExtension((V3Extension)keyUsage);
                policyInformationArray = new GeneralNames();
                policyInformationArray.addName(new GeneralName(1, (Object)"smimetest@iaik.at"));
                policyInformationArray.addName(new GeneralName(1, (Object)"smimetest@iaik.tugraz.at"));
                subjectAltName = new SubjectAltName((GeneralNames)policyInformationArray);
                x509Certificate.addExtension((V3Extension)subjectAltName);
            }
            object = "This certificate only may be used for test purposes";
            keyUsage = new PolicyQualifierInfo(null, null, (String)object);
            policyInformationArray = new PolicyInformation[]{new PolicyInformation(new ObjectID("1.3.6.1.4.1.2706.2.2.4.1.1.1.1"), new PolicyQualifierInfo[]{keyUsage})};
            subjectAltName = new CertificatePolicies(policyInformationArray);
            SubjectKeyIdentifier subjectKeyIdentifier = new SubjectKeyIdentifier(x509Certificate.getPublicKey());
            x509Certificate.addExtension((V3Extension)subjectKeyIdentifier);
            x509Certificate.addExtension((V3Extension)subjectAltName);
            x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
            x509Certificate.sign(algorithmID, privateKey);
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Error creating the certificate: " + certificateException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Error creating the certificate: " + invalidKeyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Error creating the certificate: " + noSuchAlgorithmException.getMessage());
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new RuntimeException("Error adding extension: " + x509ExtensionException.getMessage());
        }
        catch (CodingException codingException) {
            throw new RuntimeException("Error adding SubjectKeyIdentifier extension: " + codingException.getMessage());
        }
        return x509Certificate;
    }

    public void addToKeyStore(KeyPair keyPair, X509Certificate[] x509CertificateArray, String string) throws KeyStoreException {
        this.key_store.setKeyEntry(string, keyPair.getPrivate(), CMSKeyStoreConstants.KS_PASSWORD, (Certificate[])x509CertificateArray);
    }
}

